/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

class NumberParser {
    private int pos;
    private static final float[] positivePowersOf10 = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f, 1.0E11f, 1.0E12f, 1.0E13f, 1.0E14f, 1.0E15f, 1.0E16f, 1.0E17f, 1.0E18f, 1.0E19f, 1.0E20f, 1.0E21f, 1.0E22f, 1.0E23f, 1.0E24f, 1.0E25f, 1.0E26f, 1.0E27f, 1.0E28f, 1.0E29f, 1.0E30f, 1.0E31f, 1.0E32f, 1.0E33f, 1.0E34f, 1.0E35f, 1.0E36f, 1.0E37f, 1.0E38f};
    private static final float[] negativePowersOf10 = new float[]{1.0f, 0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f, 1.0E-9f, 1.0E-10f, 1.0E-11f, 1.0E-12f, 1.0E-13f, 1.0E-14f, 1.0E-15f, 1.0E-16f, 1.0E-17f, 1.0E-18f, 1.0E-19f, 1.0E-20f, 1.0E-21f, 1.0E-22f, 1.0E-23f, 1.0E-24f, 1.0E-25f, 1.0E-26f, 1.0E-27f, 1.0E-28f, 1.0E-29f, 1.0E-30f, 1.0E-31f, 1.0E-32f, 1.0E-33f, 1.0E-34f, 1.0E-35f, 1.0E-36f, 1.0E-37f, 1.0E-38f};

    NumberParser() {
    }

    int getEndPos() {
        return this.pos;
    }

    float parseNumber(String input, int startpos, int len) {
        boolean isNegative = false;
        long significand = 0L;
        int numDigits = 0;
        int numLeadingZeroes = 0;
        int numTrailingZeroes = 0;
        boolean decimalSeen = false;
        int decimalPos = 0;
        long TOO_BIG = 0xCCCCCCCCCCCCCCCL;
        this.pos = startpos;
        if (this.pos >= len) {
            return Float.NaN;
        }
        char ch = input.charAt(this.pos);
        switch (ch) {
            case '-': {
                isNegative = true;
            }
            case '+': {
                ++this.pos;
            }
        }
        int sigStart = this.pos;
        while (this.pos < len) {
            ch = input.charAt(this.pos);
            if (ch == '0') {
                if (numDigits == 0) {
                    ++numLeadingZeroes;
                } else {
                    ++numTrailingZeroes;
                }
            } else if (ch >= '1' && ch <= '9') {
                numDigits += numTrailingZeroes;
                while (numTrailingZeroes > 0) {
                    if (significand > TOO_BIG) {
                        return Float.NaN;
                    }
                    significand *= 10L;
                    --numTrailingZeroes;
                }
                if (significand > TOO_BIG) {
                    return Float.NaN;
                }
                significand = significand * 10L + (long)(ch - 48);
                ++numDigits;
                if (significand < 0L) {
                    return Float.NaN;
                }
            } else {
                if (ch != '.' || decimalSeen) break;
                decimalPos = this.pos - sigStart;
                decimalSeen = true;
            }
            ++this.pos;
        }
        if (decimalSeen && this.pos == decimalPos + 1) {
            return Float.NaN;
        }
        if (numDigits == 0) {
            if (numLeadingZeroes == 0) {
                return Float.NaN;
            }
            numDigits = 1;
        }
        int exponent = decimalSeen ? decimalPos - numLeadingZeroes - numDigits : numTrailingZeroes;
        if (this.pos < len && ((ch = input.charAt(this.pos)) == 'E' || ch == 'e')) {
            boolean expIsNegative = false;
            int expVal = 0;
            boolean abortExponent = false;
            ++this.pos;
            if (this.pos == len) {
                return Float.NaN;
            }
            switch (input.charAt(this.pos)) {
                case '-': {
                    expIsNegative = true;
                }
                case '+': {
                    ++this.pos;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    abortExponent = true;
                    --this.pos;
                }
            }
            if (!abortExponent) {
                int expStart = this.pos;
                while (this.pos < len && (ch = input.charAt(this.pos)) >= '0' && ch <= '9') {
                    if ((long)expVal > TOO_BIG) {
                        return Float.NaN;
                    }
                    expVal = expVal * 10 + (ch - 48);
                    ++this.pos;
                }
                if (this.pos == expStart) {
                    return Float.NaN;
                }
                exponent = expIsNegative ? (exponent -= expVal) : (exponent += expVal);
            }
        }
        if (exponent + numDigits > 39 || exponent + numDigits < -44) {
            return Float.NaN;
        }
        float f = significand;
        if (significand != 0L) {
            if (exponent > 0) {
                f *= positivePowersOf10[exponent];
            } else if (exponent < 0) {
                if (exponent < -38) {
                    f = (float)((double)f * 1.0E-20);
                    exponent += 20;
                }
                f *= negativePowersOf10[-exponent];
            }
        }
        return isNegative ? -f : f;
    }
}

