/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.Convention;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReadOptionsBuilder;
import com.cedarsoftware.util.io.WriteOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class JsonIo {
    public static String toJson(Object srcObject, WriteOptions writeOptions) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            JsonWriter writer = new JsonWriter(stream, writeOptions);
            writer.write(srcObject);
            writer.close();
            return stream.toString();
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to convert object to JSON", e);
        }
    }

    public static void toJson(OutputStream out, Object source, WriteOptions writeOptions) {
        try {
            JsonWriter writer = new JsonWriter(out, writeOptions);
            writer.write(source);
            writer.close();
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to convert object and send in JSON format to OutputStream.", e);
        }
    }

    public static <T> T toObjects(String json, ReadOptions readOptions, Class<T> rootType) {
        if (json == null) {
            return null;
        }
        return JsonIo.toObjects(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), readOptions, rootType);
    }

    public static <T> T toObjects(InputStream in, ReadOptions readOptions, Class<T> rootType) {
        try (JsonReader jr = new JsonReader(in, readOptions);){
            T t = jr.readObject(rootType);
            return t;
        }
    }

    public static JsonObject toJsonValues(String json, ReadOptions readOptions) {
        if (json == null) {
            return null;
        }
        return JsonIo.toJsonValues(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), readOptions);
    }

    public static JsonObject toJsonValues(InputStream inputStream, ReadOptions readOptions) {
        Convention.throwIfNull(inputStream, "inputStream cannot be null");
        if (readOptions == null) {
            readOptions = new ReadOptionsBuilder().returnAsMaps().build();
        } else {
            readOptions.ensureUsingMaps();
        }
        try (JsonReader jr = new JsonReader(inputStream, readOptions);){
            JsonObject jsonObject = jr.readObject(JsonObject.class);
            return jsonObject;
        }
    }

    public static String formatJson(String json, ReadOptions readOptions, WriteOptions writeOptions) {
        if (writeOptions.isBuilt()) {
            writeOptions = new WriteOptions(writeOptions).prettyPrint(true);
        }
        Object object = JsonReader.toObjects(json, readOptions.ensureUsingMaps(), null);
        return JsonWriter.toJson(object, writeOptions.prettyPrint(true));
    }

    public static String formatJson(String json) {
        return JsonIo.formatJson(json, new ReadOptionsBuilder().returnAsMaps().build(), new WriteOptions().prettyPrint(true));
    }

    public static <T> T deepCopy(Object source, ReadOptions readOptions, WriteOptions writeOptions) {
        if (source == null) {
            return null;
        }
        String json = JsonIo.toJson(source, writeOptions);
        return (T)JsonIo.toObjects(json, readOptions, source.getClass());
    }
}

