/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.factory.DateFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarFactory
implements JsonReader.ClassFactory {
    @Override
    public Object newInstance(Class<?> c, JsonObject jObj) {
        Object value = jObj.getValue();
        if (value instanceof String) {
            return this.fromString((String)value);
        }
        if (value instanceof Number) {
            return this.fromNumber((Number)value);
        }
        return this.fromJsonObject(c, jObj);
    }

    private Object fromString(String value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateFactory.parseDate(value));
        return calendar;
    }

    private Object fromNumber(Number value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(value.longValue()));
        return calendar;
    }

    protected Object fromJsonObject(Class<?> c, JsonObject object) {
        String time = null;
        try {
            time = (String)object.get("time");
            if (time == null) {
                throw new JsonIoException("Calendar missing 'time' field");
            }
            String zone = (String)object.get("zone");
            TimeZone tz = zone == null ? null : TimeZone.getTimeZone(zone);
            Date date = DateFactory.parseDate(time);
            Calendar calendar = c == Calendar.class ? Calendar.getInstance() : (Calendar)MetaUtils.newInstance(c, null);
            calendar.setTime(date);
            if (tz != null) {
                calendar.setTimeZone(tz);
            }
            return calendar;
        }
        catch (Exception e) {
            throw new JsonIoException("Failed to parse calendar, time: " + time);
        }
    }

    private Class<?> extractClass(JsonObject object) {
        if (object.getTarget() != null) {
            return object.getTarget().getClass();
        }
        return MetaUtils.classForName(object.getType(), object.getClass().getClassLoader());
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

