/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class MonthDayFactory
extends AbstractTemporalFactory<MonthDay> {
    public static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();

    public MonthDayFactory(DateTimeFormatter dateFormatter, ZoneId zoneId) {
        super(dateFormatter, zoneId);
    }

    public MonthDayFactory() {
        super(FORMATTER, ZoneId.systemDefault());
    }

    @Override
    protected MonthDay fromString(String s) {
        try {
            return MonthDay.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            ZonedDateTime dt = this.convertToZonedDateTime(s);
            return MonthDay.of(dt.getYear(), dt.getMonthValue());
        }
    }

    @Override
    protected MonthDay fromJsonObject(JsonObject job, ReaderContext context) {
        Number month = (Number)job.get("month");
        Number day = (Number)job.get("day");
        return MonthDay.of(month.intValue(), day.intValue());
    }
}

