/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source
 * <a href="http://guava-libraries.googlecode.com">Guava libraries</a>.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 * <li>{@link com.diffplug.common.base.Ascii}
 * <li>{@link com.diffplug.common.base.CaseFormat}
 * <li>{@link com.diffplug.common.base.CharMatcher}
 * <li>{@link java.nio.charset.StandardCharsets}
 * <li>{@link com.diffplug.common.base.Joiner}
 * <li>{@link com.diffplug.common.base.Splitter}
 * <li>{@link com.diffplug.common.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 * <li>{@link com.diffplug.common.base.Function},
 *     {@link com.diffplug.common.base.Functions}
 * <li>{@link com.diffplug.common.base.Predicate},
 *     {@link com.diffplug.common.base.Predicates}
 * <li>{@link com.diffplug.common.base.Equivalence}
 * <li>{@link com.diffplug.common.base.Converter}
 * <li>{@link com.diffplug.common.base.Supplier},
 *     {@link com.diffplug.common.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 * <li>{@link com.diffplug.common.base.Defaults}
 * <li>{@link com.diffplug.common.base.Enums}
 * <li>{@link com.diffplug.common.base.Objects}
 * <li>{@link com.diffplug.common.base.Optional}
 * <li>{@link com.diffplug.common.base.Preconditions}
 * <li>{@link com.diffplug.common.base.Stopwatch}
 * <li>{@link com.diffplug.common.base.Throwables}
 * </ul>
 *
 */
@ParametersAreNonnullByDefault
package com.diffplug.common.base;

import javax.annotation.ParametersAreNonnullByDefault;
