/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.wtp;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public final class EclipseWtpFormatterStep {
    private static final String NAME = "eclipse wtp formatters";
    private static final String FORMATTER_PACKAGE = "com.diffplug.spotless.extra.eclipse.wtp.";
    private static final String DEFAULT_VERSION = "4.7.3a";
    private static final String FORMATTER_METHOD = "format";

    private EclipseWtpFormatterStep() {
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static EclipseBasedStepBuilder createCssBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - css", provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)state -> EclipseWtpFormatterStep.applyWithoutFile("EclipseCssFormatterStepImpl", state)));
    }

    public static EclipseBasedStepBuilder createHtmlBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - html", provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)state -> EclipseWtpFormatterStep.applyWithoutFile("EclipseHtmlFormatterStepImpl", state)));
    }

    public static EclipseBasedStepBuilder createJsBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - js", provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)state -> EclipseWtpFormatterStep.applyWithoutFile("EclipseJsFormatterStepImpl", state)));
    }

    public static EclipseBasedStepBuilder createJsonBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - json", provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)state -> EclipseWtpFormatterStep.applyWithoutFile("EclipseJsonFormatterStepImpl", state)));
    }

    public static EclipseBasedStepBuilder createXmlBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - xml", provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)state -> EclipseWtpFormatterStep.applyWithFile("EclipseXmlFormatterStepImpl", state)));
    }

    private static FormatterFunc applyWithoutFile(String className, EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = state.loadClass(FORMATTER_PACKAGE + className);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        };
    }

    private static FormatterFuncWithFile applyWithFile(String className, EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = state.loadClass(FORMATTER_PACKAGE + className);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class, String.class);
        return (input, source) -> {
            try {
                return (String)method.invoke(formatter, input, source.getAbsolutePath());
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        };
    }

    private static interface FormatterFuncWithFile
    extends FormatterFunc {
        default public String apply(String input) throws Exception {
            throw new UnsupportedOperationException("Formatter requires file path of source.");
        }

        public String apply(String var1, File var2) throws Exception;
    }
}

