/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.incremental;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class ObjectDigestOutputStream
extends ObjectOutputStream {
    private final MessageDigest messageDigest;

    private ObjectDigestOutputStream(DigestOutputStream out) throws IOException {
        super(out);
        this.messageDigest = out.getMessageDigest();
    }

    static ObjectDigestOutputStream create() throws IOException {
        return new ObjectDigestOutputStream(ObjectDigestOutputStream.createDigestOutputStream());
    }

    byte[] digest() {
        return this.messageDigest.digest();
    }

    private static DigestOutputStream createDigestOutputStream() {
        MessageDigest result;
        OutputStream nullOutputStream = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        try {
            result = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 digest algorithm not available", e);
        }
        return new DigestOutputStream(nullOutputStream, result);
    }
}

