/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.java;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.P2Mirror;
import com.diffplug.spotless.extra.P2Provisioner;
import com.diffplug.spotless.extra.java.EclipseJdtFormatterStep;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystemSession;

public class Eclipse
implements FormatterStepFactory {
    @Parameter
    private String file;
    @Parameter
    private String version;
    @Parameter
    private List<P2Mirror> p2Mirrors = new ArrayList<P2Mirror>();
    @Parameter
    private Boolean sortMembersDoNotSortFields = true;
    @Parameter
    private Boolean sortMembersEnabled = false;
    @Parameter
    private String sortMembersOrder;
    @Parameter
    private String sortMembersVisibilityOrder;
    @Parameter
    private Boolean sortMembersVisibilityOrderEnabled = false;
    private File cacheDirectory;

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig stepConfig) {
        EclipseJdtFormatterStep.Builder eclipseConfig = EclipseJdtFormatterStep.createBuilder((Provisioner)stepConfig.getProvisioner(), (P2Provisioner)stepConfig.getP2Provisioner());
        eclipseConfig.setVersion(this.version == null ? EclipseJdtFormatterStep.defaultVersion() : this.version);
        if (this.file != null) {
            File settingsFile = stepConfig.getFileLocator().locateFile(this.file);
            eclipseConfig.setPreferences(Arrays.asList(settingsFile));
        }
        eclipseConfig.setP2Mirrors(this.p2Mirrors);
        if (this.cacheDirectory != null) {
            eclipseConfig.setCacheDirectory(this.cacheDirectory);
        }
        if (this.sortMembersEnabled != null) {
            eclipseConfig.sortMembersEnabled(this.sortMembersEnabled.booleanValue());
        }
        if (this.sortMembersOrder != null) {
            eclipseConfig.sortMembersOrder(this.sortMembersOrder);
        }
        if (this.sortMembersDoNotSortFields != null) {
            eclipseConfig.sortMembersDoNotSortFields(this.sortMembersDoNotSortFields.booleanValue());
        }
        if (this.sortMembersVisibilityOrder != null) {
            eclipseConfig.sortMembersVisibilityOrder(this.sortMembersVisibilityOrder);
        }
        if (this.sortMembersVisibilityOrderEnabled != null) {
            eclipseConfig.sortMembersVisibilityOrderEnabled(this.sortMembersVisibilityOrderEnabled.booleanValue());
        }
        if (this.cacheDirectory != null) {
            eclipseConfig.setCacheDirectory(this.cacheDirectory);
        }
        return eclipseConfig.build();
    }

    @Override
    public void init(RepositorySystemSession repositorySystemSession) {
        this.cacheDirectory = repositorySystemSession.getLocalRepository().getBasedir();
    }
}

