/*
 * Decompiled with CFR 0.152.
 */
package com.echatsoft.echatsdk.utils.pub;

import android.text.TextUtils;
import com.echatsoft.echatsdk.core.interfaces.IUserInfoManager;
import com.echatsoft.echatsdk.core.model.UserInfo;
import com.echatsoft.echatsdk.core.utils.EChatCoreUtils;
import com.echatsoft.echatsdk.core.utils.ProcessManager;
import com.echatsoft.echatsdk.core.utils.aes.AesException;
import com.echatsoft.echatsdk.core.utils.aes.AesUtils;
import com.echatsoft.echatsdk.core.utils.provider.MultiProcessSharedPreferences;
import com.echatsoft.echatsdk.sdk.pro.g0;
import com.echatsoft.echatsdk.sdk.pro.z;

public class UserInfoManager
implements IUserInfoManager {
    private static final String TAG = "EChat_User";
    private static final String KV_CURRENT_USER_INFO = "kv_current_user_info";
    private static final String KV_WAIT_USER_INFO = "kv_wait_user_info";
    private static final String KV_CLEAR_USER_INFO = "kv_clear_user_info";
    private static final String KV_MIGRATED_V2_USER_INFO_MANAGER = "kv_migrated_v2_user_info_manager";
    private boolean migratedToV2;
    private boolean clearUserInfo;
    private UserInfo currentUserInfo;
    private UserInfo waitUserInfo;
    private String appId;
    private String encodingKey;

    private UserInfoManager() {
        UserInfoManager userInfoManager = this;
        userInfoManager.reload();
    }

    public static UserInfoManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    private MultiProcessSharedPreferences getMultiSP() {
        return MultiProcessSharedPreferences.getInstance((String)"EChatSP");
    }

    private <T> void updateChatProcessValue(String string2, T t4) {
        EChatCoreUtils.updateValue((String)string2, t4, (String)"com.echatsoft.echatsdk.action.CHAT_MESSAGE");
    }

    public /* synthetic */ UserInfoManager(1 var1_1) {
        this();
    }

    public IUserInfoManager setUserInfo(UserInfo userInfo) {
        if (!TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.encodingKey)) {
            if (userInfo == null) {
                boolean bl = z.l();
                EChatCoreUtils.warn((String)TAG, (String)"setUserInfo fail, userInfo is null", (boolean)bl);
                return this;
            }
            if (TextUtils.isEmpty((CharSequence)userInfo.getUid())) {
                boolean bl = z.l();
                EChatCoreUtils.warn((String)TAG, (String)"setUserInfo fail, userInfo uid is null", (boolean)bl);
                return this;
            }
            if (z.d()) {
                EChatCoreUtils.log((String)TAG, (String)("setUserInfo -> " + userInfo.toJSONString()), (boolean)z.r);
            }
            UserInfoManager userInfoManager = this;
            userInfoManager.migratedToV2 = true;
            userInfoManager.clearUserInfo = false;
            this.waitUserInfo = userInfo;
            this.getMultiSP().edit().putString(KV_WAIT_USER_INFO, userInfo.toJSONString()).putBoolean(KV_MIGRATED_V2_USER_INFO_MANAGER, true).commit();
            if (!ProcessManager.getInstance().isChatProcess()) {
                this.updateChatProcessValue("kv_refresh_v2_user_info", userInfo);
            }
            return this;
        }
        boolean bl = z.l();
        EChatCoreUtils.warn((String)TAG, (String)"setUserInfo fail, serverAppId and serverEncodingKey is null, please check EChatSDK.init(...).", (boolean)bl);
        return this;
    }

    public UserInfo getUserInfo() {
        if (!ProcessManager.getInstance().isChatProcess()) {
            this.reload();
        }
        if (this.clearUserInfo) {
            return null;
        }
        UserInfo userInfo = this.waitUserInfo;
        if (userInfo != null) {
            return userInfo;
        }
        return this.currentUserInfo;
    }

    public IUserInfoManager clearUserInfo() {
        this.clearUserInfo = true;
        this.getMultiSP().edit().putBoolean(KV_CLEAR_USER_INFO, this.clearUserInfo).commit();
        if (!ProcessManager.getInstance().isChatProcess()) {
            this.updateChatProcessValue("kv_clean_v2_user_info", Boolean.TRUE);
        }
        return this;
    }

    public void updateWaitUserInfo(UserInfo userInfo) {
        if (z.d()) {
            EChatCoreUtils.log((String)TAG, (String)("onReceive: KV_REFRESH_V2_USER_INFO -> " + userInfo.toJSONString()), (boolean)z.r);
        }
        UserInfoManager userInfoManager = this;
        userInfoManager.waitUserInfo = userInfo;
        userInfoManager.clearUserInfo = false;
    }

    public void updateClearFlags(boolean bl) {
        if (z.d()) {
            EChatCoreUtils.log((String)TAG, (String)("onReceive: KV_CLEAR_USER_INFO -> " + bl), (boolean)z.r);
        }
        this.clearUserInfo = bl;
    }

    public UserInfoManager reload() {
        StringBuilder stringBuilder;
        UserInfoManager userInfoManager = this;
        userInfoManager.currentUserInfo = (UserInfo)UserInfo.parseObject((String)userInfoManager.getMultiSP().getString(KV_CURRENT_USER_INFO, null), UserInfo.class);
        userInfoManager.waitUserInfo = (UserInfo)UserInfo.parseObject((String)userInfoManager.getMultiSP().getString(KV_WAIT_USER_INFO, null), UserInfo.class);
        userInfoManager.clearUserInfo = userInfoManager.getMultiSP().getBoolean(KV_CLEAR_USER_INFO, false);
        userInfoManager.migratedToV2 = userInfoManager.getMultiSP().getBoolean(KV_MIGRATED_V2_USER_INFO_MANAGER, false);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(">>>> init reload configs");
        if (userInfoManager.currentUserInfo != null) {
            stringBuilder2.append("\n> current -> ").append(this.currentUserInfo.toJSONString());
        } else {
            stringBuilder2.append("\n> current -> null");
        }
        if (this.waitUserInfo != null) {
            stringBuilder2.append("\n> wait -> ").append(this.waitUserInfo.toJSONString());
        } else {
            stringBuilder2.append("\n> wait -> null");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("\n> clear -> ").append(this.clearUserInfo);
        stringBuilder3.append("\n> migratedToV2 -> ").append(this.migratedToV2);
        if (z.d()) {
            EChatCoreUtils.log((String)TAG, (String)stringBuilder2.toString(), (boolean)z.r);
        }
        return this;
    }

    public UserInfoManager setAesParams(String string2, String string3) {
        this.appId = string2;
        this.encodingKey = string3;
        return this;
    }

    public String getMetaData() {
        return this.getMetaData(false);
    }

    public String getMetaData(boolean bl) {
        if (!ProcessManager.getInstance().isChatProcess()) {
            ((UserInfoManager)((Object)string3)).reload();
        }
        if (bl) {
            if (((UserInfoManager)((Object)string3)).clearUserInfo) {
                ((UserInfoManager)((Object)string3)).currentUserInfo = null;
                ((UserInfoManager)((Object)string3)).waitUserInfo = null;
                ((UserInfoManager)((Object)string3)).getMultiSP().edit().remove(KV_CURRENT_USER_INFO).remove(KV_WAIT_USER_INFO).remove(KV_CLEAR_USER_INFO).commit();
            } else {
                UserInfo userInfo = ((UserInfoManager)((Object)string3)).waitUserInfo;
                if (userInfo != null) {
                    ((UserInfoManager)((Object)string3)).currentUserInfo = userInfo;
                    ((UserInfoManager)((Object)string3)).waitUserInfo = null;
                    ((UserInfoManager)((Object)string3)).getMultiSP().edit().putString(KV_CURRENT_USER_INFO, ((UserInfoManager)((Object)string3)).currentUserInfo.toJSONString()).remove(KV_WAIT_USER_INFO).commit();
                }
            }
        }
        String string2 = null;
        if (((UserInfoManager)((Object)string3)).currentUserInfo != null && !TextUtils.isEmpty((CharSequence)((UserInfoManager)((Object)string3)).appId) && !TextUtils.isEmpty((CharSequence)((UserInfoManager)((Object)string3)).encodingKey)) {
            AesUtils aesUtils;
            AesUtils aesUtils2 = aesUtils;
            UserInfoManager userInfoManager = string3;
            UserInfoManager userInfoManager2 = string3;
            UserInfoManager userInfoManager3 = userInfoManager2;
            String string3 = userInfoManager2.encodingKey;
            try {
                aesUtils2(string3, userInfoManager3.appId);
                string2 = aesUtils.encrypt(userInfoManager.currentUserInfo.toXml());
            }
            catch (AesException aesException) {
                boolean bl2 = z.l();
                EChatCoreUtils.error((String)TAG, (String)"getMetaData error", (Throwable)aesException, (boolean)bl2);
            }
        }
        if (z.d()) {
            boolean bl3 = z.r;
            EChatCoreUtils.log((String)TAG, (String)g0.a("getMetaData v2 -> ", string2), (boolean)bl3);
        }
        return string2;
    }

    public boolean isMigratedV2() {
        return this.currentUserInfo != null || this.waitUserInfo != null || this.clearUserInfo;
    }

    public static class LazyHolder {
        private static final UserInfoManager INSTANCE = new UserInfoManager(null);

        private LazyHolder() {
        }
    }
}

