/*
 * Decompiled with CFR 0.152.
 */
package com.echatsoft.echatsdk.utils.pub.helper;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import com.echatsoft.echatsdk.utils.pub.helper.chrome.shared.CustomTabsHelper;
import com.echatsoft.echatsdk.utils.pub.helper.chrome.shared.ServiceConnection;
import com.echatsoft.echatsdk.utils.pub.helper.chrome.shared.ServiceConnectionCallback;
import java.util.List;

public class CustomTabActivityHelper
implements ServiceConnectionCallback {
    private CustomTabsSession mCustomTabsSession;
    private CustomTabsClient mClient;
    private CustomTabsServiceConnection mConnection;
    private ConnectionCallback mConnectionCallback;

    public static void openCustomTab(Activity activity, CustomTabsIntent customTabsIntent, Uri uri, CustomTabFallback customTabFallback) {
        String string2 = CustomTabsHelper.getPackageNameToUse((Context)activity);
        if (string2 == null) {
            if (customTabFallback != null) {
                customTabFallback.openUri(activity, uri);
            }
        } else {
            customTabsIntent.intent.setPackage(string2);
            customTabsIntent.launchUrl((Context)activity, uri);
        }
    }

    public void unbindCustomTabsService(Activity activity) {
        CustomTabsServiceConnection customTabsServiceConnection = this.mConnection;
        if (customTabsServiceConnection == null) {
            return;
        }
        CustomTabActivityHelper customTabActivityHelper = this;
        activity.unbindService((android.content.ServiceConnection)customTabsServiceConnection);
        customTabActivityHelper.mClient = null;
        customTabActivityHelper.mCustomTabsSession = null;
        customTabActivityHelper.mConnection = null;
    }

    public CustomTabsSession getSession() {
        CustomTabsClient customTabsClient = this.mClient;
        if (customTabsClient == null) {
            this.mCustomTabsSession = null;
        } else if (this.mCustomTabsSession == null) {
            this.mCustomTabsSession = customTabsClient.newSession(null);
        }
        return this.mCustomTabsSession;
    }

    public void setConnectionCallback(ConnectionCallback connectionCallback) {
        this.mConnectionCallback = connectionCallback;
    }

    public void bindCustomTabsService(Activity object) {
        ServiceConnection serviceConnection;
        if (this.mClient != null) {
            return;
        }
        String string2 = CustomTabsHelper.getPackageNameToUse((Context)object);
        if (string2 == null) {
            return;
        }
        Activity activity = object;
        object = serviceConnection;
        serviceConnection = new ServiceConnection(this);
        this.mConnection = object;
        CustomTabsClient.bindCustomTabsService((Context)activity, (String)string2, (CustomTabsServiceConnection)object);
    }

    public boolean mayLaunchUrl(Uri uri, Bundle bundle, List<Bundle> list) {
        if (this.mClient == null) {
            return false;
        }
        if ((this = this.getSession()) == null) {
            return false;
        }
        return this.mayLaunchUrl(uri, bundle, list);
    }

    @Override
    public void onServiceConnected(CustomTabsClient customTabsClient) {
        ((CustomTabActivityHelper)((Object)connectionCallback)).mClient = customTabsClient;
        customTabsClient.warmup(0L);
        ConnectionCallback connectionCallback = ((CustomTabActivityHelper)((Object)connectionCallback)).mConnectionCallback;
        if (connectionCallback != null) {
            connectionCallback.onCustomTabsConnected();
        }
    }

    @Override
    public void onServiceDisconnected() {
        ((CustomTabActivityHelper)((Object)connectionCallback)).mClient = null;
        ((CustomTabActivityHelper)((Object)connectionCallback)).mCustomTabsSession = null;
        ConnectionCallback connectionCallback = ((CustomTabActivityHelper)((Object)connectionCallback)).mConnectionCallback;
        if (connectionCallback != null) {
            connectionCallback.onCustomTabsDisconnected();
        }
    }

    public static interface CustomTabFallback {
        public void openUri(Activity var1, Uri var2);
    }

    public static interface ConnectionCallback {
        public void onCustomTabsConnected();

        public void onCustomTabsDisconnected();
    }
}

