/*
 * Decompiled with CFR 0.152.
 */
package com.echatsoft.echatsdk.utils.pub.helper.chrome.shared;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.echatsoft.echatsdk.utils.pub.helper.chrome.shared.KeepAliveService;
import java.util.ArrayList;

public class CustomTabsHelper {
    private static final String TAG = "CustomTabsHelper";
    static final String STABLE_PACKAGE = "com.android.chrome";
    static final String BETA_PACKAGE = "com.chrome.beta";
    static final String DEV_PACKAGE = "com.chrome.dev";
    static final String LOCAL_PACKAGE = "com.google.android.apps.chrome";
    private static final String EXTRA_CUSTOM_TABS_KEEP_ALIVE = "android.support.customtabs.extra.KEEP_ALIVE";
    private static final String ACTION_CUSTOM_TABS_CONNECTION = "android.support.customtabs.action.CustomTabsService";
    private static String sPackageNameToUse;

    private CustomTabsHelper() {
    }

    public static void addKeepAliveExtra(Context context, Intent intent) {
        intent.putExtra(EXTRA_CUSTOM_TABS_KEEP_ALIVE, (Parcelable)new Intent().setClassName(context.getPackageName(), KeepAliveService.class.getCanonicalName()));
    }

    public static String getPackageNameToUse(Context context) {
        ArrayList arrayList;
        Intent intent;
        String string2 = sPackageNameToUse;
        if (string2 != null) {
            return string2;
        }
        string2 = context.getPackageManager();
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
        Object object = string2.resolveActivity(intent2, 0);
        String string3 = null;
        if (object != null) {
            string3 = ((ResolveInfo)object).activityInfo.packageName;
        }
        object = arrayList;
        arrayList = new ArrayList();
        for (ResolveInfo resolveInfo : string2.queryIntentActivities(intent2, 0)) {
            Intent intent3 = new Intent();
            intent3.setAction(ACTION_CUSTOM_TABS_CONNECTION);
            intent3.setPackage(resolveInfo.activityInfo.packageName);
            if (string2.resolveService(intent3, 0) == null) continue;
            ((ArrayList)object).add(resolveInfo.activityInfo.packageName);
        }
        if (((ArrayList)object).isEmpty()) {
            sPackageNameToUse = null;
        } else if (((ArrayList)object).size() == 1) {
            sPackageNameToUse = (String)((ArrayList)object).get(0);
        } else if (!TextUtils.isEmpty((CharSequence)string3) && !CustomTabsHelper.hasSpecializedHandlerIntents(context, intent2) && ((ArrayList)object).contains(string3)) {
            sPackageNameToUse = string3;
        } else if (((ArrayList)object).contains(STABLE_PACKAGE)) {
            sPackageNameToUse = STABLE_PACKAGE;
        } else if (((ArrayList)object).contains(BETA_PACKAGE)) {
            sPackageNameToUse = BETA_PACKAGE;
        } else if (((ArrayList)object).contains(DEV_PACKAGE)) {
            sPackageNameToUse = DEV_PACKAGE;
        } else if (((ArrayList)object).contains(LOCAL_PACKAGE)) {
            sPackageNameToUse = LOCAL_PACKAGE;
        }
        return sPackageNameToUse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasSpecializedHandlerIntents(Context object, Intent intent) {
        object = object.getPackageManager().queryIntentActivities(intent, 64);
        if (object == null) return false;
        if (object.size() == 0) return false;
        try {
            object = object.iterator();
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)TAG, (String)"Runtime exception while getting specialized handlers");
        }
        while (true) {
            if (!object.hasNext()) return false;
            intent = (ResolveInfo)object.next();
            IntentFilter intentFilter = intent.filter;
            if (intentFilter == null) continue;
            if (intentFilter.countDataAuthorities() == 0) continue;
            if (intentFilter.countDataPaths() == 0) continue;
            if (intent.activityInfo != null) return true;
            continue;
            break;
        }
        return false;
    }

    public static String[] getPackages() {
        return new String[]{"", STABLE_PACKAGE, BETA_PACKAGE, DEV_PACKAGE, LOCAL_PACKAGE};
    }
}

