/*
 * Decompiled with CFR 0.152.
 */
package com.echatsoft.echatsdk.utils.pub.media;

import android.media.MediaPlayer;
import android.net.Uri;
import android.view.Surface;
import com.echat.jzvd.JZMediaInterface;
import com.echat.jzvd.JZMediaManager;
import com.echat.jzvd.JZVideoPlayerManager;
import com.echatsoft.echatsdk.core.EChatCore;
import com.echatsoft.echatsdk.core.utils.EChatCoreUtils;
import java.io.FileDescriptor;
import java.lang.reflect.Method;
import java.util.Map;

public class JZCustomMediaSystem
extends JZMediaInterface
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnVideoSizeChangedListener {
    public MediaPlayer mediaPlayer;

    public void start() {
        this.mediaPlayer.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare() {
        block8: {
            JZCustomMediaSystem jZCustomMediaSystem = this;
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            jZCustomMediaSystem.mediaPlayer.setLooping(this.jzDataSource.looping);
            jZCustomMediaSystem.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            jZCustomMediaSystem.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            jZCustomMediaSystem.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            jZCustomMediaSystem.mediaPlayer.setScreenOnWhilePlaying(true);
            jZCustomMediaSystem.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
            jZCustomMediaSystem.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            jZCustomMediaSystem.mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            jZCustomMediaSystem.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            if (EChatCoreUtils.isContent((String)jZCustomMediaSystem.jzDataSource.getCurrentUrl().toString())) {
                this.mediaPlayer.setDataSource(EChatCore.z().r().getBaseContext(), Uri.parse((String)this.jzDataSource.getCurrentUrl().toString()));
                break block8;
            }
            if (this.jzDataSource.getCurrentUrl() instanceof FileDescriptor) {
                this.mediaPlayer.setDataSource((FileDescriptor)this.jzDataSource.getCurrentUrl());
                break block8;
            }
            Method method = MediaPlayer.class.getDeclaredMethod("setDataSource", String.class, Map.class);
            MediaPlayer mediaPlayer = this.mediaPlayer;
            Object[] objectArray = new Object[2];
            objectArray[0] = this.jzDataSource.getCurrentUrl().toString();
            objectArray[1] = this.jzDataSource.headerMap;
            method.invoke((Object)mediaPlayer, objectArray);
        }
        try {
            this.mediaPlayer.prepareAsync();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pause() {
        this.mediaPlayer.pause();
    }

    public boolean isPlaying() {
        return this.mediaPlayer.isPlaying();
    }

    public void seekTo(long l4) {
        MediaPlayer mediaPlayer = this.mediaPlayer;
        try {
            mediaPlayer.seekTo((int)l4);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    public void release() {
        JZCustomMediaSystem jZCustomMediaSystem = jZCustomMediaSystem.mediaPlayer;
        if (jZCustomMediaSystem != null) {
            jZCustomMediaSystem.release();
        }
    }

    public long getCurrentPosition() {
        JZCustomMediaSystem jZCustomMediaSystem = jZCustomMediaSystem.mediaPlayer;
        if (jZCustomMediaSystem != null) {
            return jZCustomMediaSystem.getCurrentPosition();
        }
        return 0L;
    }

    public long getDuration() {
        JZCustomMediaSystem jZCustomMediaSystem = jZCustomMediaSystem.mediaPlayer;
        if (jZCustomMediaSystem != null) {
            return jZCustomMediaSystem.getDuration();
        }
        return 0L;
    }

    public void setSurface(Surface surface) {
        this.mediaPlayer.setSurface(surface);
    }

    public void setVolume(float f5, float f6) {
        this.mediaPlayer.setVolume(f5, f6);
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        mediaPlayer.start();
        if (this.jzDataSource.getCurrentUrl().toString().toLowerCase().contains("mp3") || this.jzDataSource.getCurrentUrl().toString().toLowerCase().contains("wav")) {
            JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                        JZVideoPlayerManager.getCurrentJzvd().onPrepared();
                    }
                }
            });
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().onAutoCompletion();
                }
            }
        });
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, final int n4) {
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().setBufferProgress(n4);
                }
            }
        });
    }

    public void onSeekComplete(MediaPlayer mediaPlayer) {
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().onSeekComplete();
                }
            }
        });
    }

    public boolean onError(MediaPlayer mediaPlayer, final int n4, final int n5) {
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    5 v02 = this;
                    int n42 = v02.n4;
                    JZVideoPlayerManager.getCurrentJzvd().onError(n42, v02.n5);
                }
            }
        });
        return true;
    }

    public boolean onInfo(MediaPlayer mediaPlayer, final int n4, final int n5) {
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    if (n4 == 3) {
                        if (JZVideoPlayerManager.getCurrentJzvd().currentState == 1 || JZVideoPlayerManager.getCurrentJzvd().currentState == 2) {
                            JZVideoPlayerManager.getCurrentJzvd().onPrepared();
                        }
                    } else {
                        6 v02 = this;
                        int n42 = v02.n4;
                        JZVideoPlayerManager.getCurrentJzvd().onInfo(n42, v02.n5);
                    }
                }
            }
        });
        return false;
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n4, int n5) {
        JZMediaManager.instance().currentVideoWidth = n4;
        JZMediaManager.instance().currentVideoHeight = n5;
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().onVideoSizeChanged();
                }
            }
        });
    }
}

