/*
 * Decompiled with CFR 0.152.
 */
package com.echatsoft.echatsdk.utils.pub.notification;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.echatsoft.echatsdk.utils.pub.notification.BaseData;
import java.util.Collections;
import java.util.List;

@Keep
public abstract class BaseNotification<T extends BaseData>
extends ContextWrapper {
    protected NotificationManager manager;
    private NotificationCompat.Builder mBuilder;
    private final T data;

    public BaseNotification(Context context, T t4) {
        BaseNotification baseNotification = this;
        super(context);
        this.data = t4;
        baseNotification.manager = (NotificationManager)context.getSystemService("notification");
        baseNotification.initGroup();
        baseNotification.initChannel();
    }

    private void initGroup() {
        block6: {
            if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannelGroup notificationChannelGroup;
                BaseNotification baseNotification = this;
                if (baseNotification.getNotificationChannelGroup(baseNotification.currentGroupId()) != null) break block6;
                BaseNotification baseNotification2 = this;
                NotificationChannelGroup notificationChannelGroup2 = notificationChannelGroup;
                BaseNotification baseNotification3 = this;
                BaseNotification baseNotification4 = baseNotification3;
                String string2 = baseNotification3.currentGroupId();
                try {
                    notificationChannelGroup = new NotificationChannelGroup(string2, (CharSequence)baseNotification4.currentGroupName());
                    baseNotification2.manager.createNotificationChannelGroup(notificationChannelGroup2);
                }
                catch (Exception exception) {
                    Log.e((String)this.TAG(), (String)"initGroup: ", (Throwable)exception);
                }
            }
        }
    }

    private void initChannel() {
        block6: {
            if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannel notificationChannel;
                if (this.manager.getNotificationChannel(this.currentChannelId()) != null) break block6;
                BaseNotification baseNotification = this;
                BaseNotification baseNotification2 = baseNotification;
                BaseNotification baseNotification3 = baseNotification;
                NotificationChannel notificationChannel2 = notificationChannel;
                BaseNotification baseNotification4 = this;
                NotificationChannel notificationChannel3 = notificationChannel2;
                BaseNotification baseNotification5 = this;
                BaseNotification baseNotification6 = baseNotification5;
                String string2 = baseNotification5.currentChannelId();
                try {
                    notificationChannel3(string2, (CharSequence)baseNotification6.currentChannelName(), 4);
                    notificationChannel.setGroup(baseNotification4.currentGroupId());
                    baseNotification2.configureChannel(notificationChannel);
                    baseNotification3.manager.createNotificationChannel(notificationChannel2);
                }
                catch (Exception exception) {
                    Log.e((String)this.TAG(), (String)"initGroup: ", (Throwable)exception);
                }
            }
        }
    }

    private void initBuilder(Context context) {
        NotificationCompat.Builder builder;
        NotificationCompat.Builder builder2 = builder;
        builder = new NotificationCompat.Builder(context, this.currentChannelId());
        this.mBuilder = builder2;
        this.configureNotify(builder2);
    }

    public static void cancel(Context context, int n4) {
        ((NotificationManager)context.getSystemService("notification")).cancel(n4);
    }

    public abstract String TAG();

    public String currentGroupId() {
        return ((BaseData)this.data).getChannelGroupId();
    }

    public String currentGroupName() {
        return ((BaseData)this.data).getChannelGroupName();
    }

    public String currentChannelId() {
        return ((BaseData)this.data).getChannelId();
    }

    public String currentChannelName() {
        return ((BaseData)this.data).getChannelName();
    }

    public T getData() {
        return this.data;
    }

    public void show() {
        BaseNotification baseNotification = this;
        baseNotification.initBuilder((Context)baseNotification);
    }

    public abstract void configureNotify(NotificationCompat.Builder var1);

    @RequiresApi(api=26)
    public abstract void configureChannel(NotificationChannel var1);

    public NotificationCompat.Builder getBuilder() {
        return this.mBuilder;
    }

    @Nullable
    public NotificationChannelGroup getNotificationChannelGroup(@NonNull String string2) {
        int n4 = Build.VERSION.SDK_INT;
        if (n4 >= 28) {
            return ((BaseNotification)((Object)this)).manager.getNotificationChannelGroup(string2);
        }
        if (n4 >= 26) {
            for (NotificationChannelGroup notificationChannelGroup : ((BaseNotification)((Object)this)).getNotificationChannelGroups()) {
                if (!notificationChannelGroup.getId().equals(string2)) continue;
                return notificationChannelGroup;
            }
            return null;
        }
        return null;
    }

    @NonNull
    public List<NotificationChannelGroup> getNotificationChannelGroups() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this.manager.getNotificationChannelGroups();
        }
        return Collections.emptyList();
    }

    public int getSmallIcon() {
        String string2 = this.getPackageName();
        int n4 = this.getResources().getIdentifier("mipush_small_notification", "drawable", string2);
        if (n4 == 0) {
            n4 = this.getApplicationInfo().icon;
        }
        return n4;
    }
}

