/*
 * Decompiled with CFR 0.152.
 */
package com.echatsoft.echatsdk.utils.pub.notification;

import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.Person;
import androidx.core.graphics.drawable.IconCompat;
import com.echatsoft.echatsdk.R;
import com.echatsoft.echatsdk.core.utils.RomUtils;
import com.echatsoft.echatsdk.core.utils.StringUtils;
import com.echatsoft.echatsdk.sdk.pro.f1;
import com.echatsoft.echatsdk.ui.notificationGoto.NotificationGotoActivity;
import com.echatsoft.echatsdk.utils.pub.notification.BaseNotification;
import com.echatsoft.echatsdk.utils.pub.notification.EChatPushData;
import java.io.Serializable;
import java.util.List;

@Keep
public class EChatNotification
extends BaseNotification<EChatPushData> {
    private final List<EChatPushData> internalPushMessages;
    private Bitmap bitIcon;

    public EChatNotification(Context context, List<EChatPushData> list) {
        List<EChatPushData> list2 = list;
        super(context, list2.get(list2.size() - 1));
        this.internalPushMessages = list;
    }

    public static Uri resourceToUri(Context context, int n4) {
        return Uri.parse((String)("android.resource://" + context.getResources().getResourcePackageName(n4) + "/" + context.getResources().getResourceTypeName(n4) + "/" + context.getResources().getResourceEntryName(n4)));
    }

    private Bitmap getLargeIcon() {
        Object object = this.bitIcon;
        if (object != null) {
            return object;
        }
        object = this.getPackageName();
        int n4 = this.getResources().getIdentifier("mipush_notification", "drawable", (String)object);
        if (n4 != 0) {
            return BitmapFactory.decodeResource((Resources)this.getResources(), (int)n4);
        }
        return null;
    }

    @Override
    public String TAG() {
        return "EChat_Notification";
    }

    @Override
    public String currentChannelName() {
        return this.getString(R.string.echat_notification_default_channel);
    }

    @Override
    public void show() {
        EChatNotification eChatNotification = this;
        super.show();
        eChatNotification.manager.notify(((EChatPushData)this.getData()).getCompanyId().intValue(), this.getBuilder().build());
    }

    public Class<?> getIntentClass() {
        return NotificationGotoActivity.class;
    }

    @Override
    public void configureNotify(NotificationCompat.Builder builder) {
        Intent intent;
        Object object;
        String string2;
        Object object2;
        boolean bl = false;
        if (RomUtils.isHarmony() && ((String[])(object2 = RomUtils.getRomInfo().getVersion().split("\\."))).length > 0) {
            try {
                if (Integer.parseInt(object2[0]) >= 3) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Object object3 = null;
        object2 = "";
        String string3 = ((EChatPushData)this.getData()).getContent();
        if (bl) {
            object2 = ((EChatPushData)this.getData()).getTitle();
            string2 = f1.a().b();
            if (string2 != null && string2.contains("zh")) {
                if (((EChatPushData)this.getData()).getUnreadCount() > 1) {
                    Object[] objectArray = new Object[3];
                    object = objectArray;
                    object[0] = ((EChatPushData)this.getData()).getUnreadCount();
                    objectArray[1] = StringUtils.getString((Context)this.getApplicationContext(), (int)R.string.echat_count);
                    objectArray[2] = string3;
                    string3 = String.format("[%d%s]%s", (Object[])object);
                }
            } else if (((EChatPushData)this.getData()).getUnreadCount() > 1) {
                Object[] objectArray = new Object[2];
                object = objectArray;
                objectArray[0] = ((EChatPushData)this.getData()).getUnreadCount();
                objectArray[1] = string3;
                string3 = String.format("[%d]%s", (Object[])object);
            }
            Log.i((String)"EChat", (String)("harmony notification: title" + (String)object2 + " contentText:" + string3 + " unread: " + ((EChatPushData)this.getData()).getUnreadCount() + " lan:" + string2));
        } else {
            object3 = new Person.Builder().setName((CharSequence)this.getString(R.string.echat_you)).build();
            if (Build.VERSION.SDK_INT >= 28) {
                object3 = new Person.Builder().setName((CharSequence)this.getString(R.string.echat_you)).build();
            }
            if (object3 == null) {
                NotificationCompat.MessagingStyle messagingStyle;
                object3 = messagingStyle;
                messagingStyle = new NotificationCompat.MessagingStyle((CharSequence)this.getString(R.string.echat_you));
            } else {
                NotificationCompat.MessagingStyle messagingStyle;
                string2 = messagingStyle;
                messagingStyle = new NotificationCompat.MessagingStyle(object3);
                object3 = string2;
            }
            if (((EChatPushData)this.getData()).getUnreadCount() > 1) {
                object2 = this.getString(R.string.echat_multi_default_content_title, new Object[]{((EChatPushData)this.getData()).getUnreadCount()});
            }
            object3.setConversationTitle((CharSequence)object2);
            string2 = new Person.Builder().setName((CharSequence)((EChatPushData)this.getData()).getTitle());
            if (!TextUtils.isEmpty((CharSequence)((EChatPushData)this.getData()).getBigIconPath()) && (((EChatPushData)this.getData()).getBigIconPath().startsWith("content://") || ((EChatPushData)this.getData()).getBigIconPath().startsWith("file://"))) {
                string2.setIcon(IconCompat.createWithContentUri((String)((EChatPushData)this.getData()).getBigIconPath()));
            }
            object = this.internalPushMessages.iterator();
            while (object.hasNext()) {
                EChatPushData eChatPushData;
                EChatPushData eChatPushData2 = eChatPushData = (EChatPushData)object.next();
                String object4 = eChatPushData2.getContent();
                long l4 = eChatPushData2.getTimestamp();
                Person person = string2.build();
                object3.addMessage(new NotificationCompat.MessagingStyle.Message((CharSequence)object4, l4, person));
            }
        }
        EChatNotification eChatNotification = this;
        string2 = intent;
        EChatNotification eChatNotification2 = this;
        string2((Context)eChatNotification2, eChatNotification2.getIntentClass());
        intent.putExtra("activity_extra_companyid", (Serializable)Long.valueOf(((EChatPushData)this.getData()).getCompanyId().intValue()));
        intent.addFlags(0x4000000);
        intent.addFlags(0x10000000);
        string2 = PendingIntent.getActivity((Context)eChatNotification, (int)((EChatPushData)eChatNotification.getData()).getCompanyId(), (Intent)string2, (int)0xA000000);
        object = RingtoneManager.getDefaultUri((int)2);
        if (object3 != null) {
            builder.setStyle((NotificationCompat.Style)object3);
        }
        builder.setContentTitle((CharSequence)object2).setContentText((CharSequence)string3).setSmallIcon(this.getSmallIcon()).setContentIntent((PendingIntent)string2).setSound((Uri)object).setPriority(2).setDefaults(-1).setCategory("msg");
    }

    @Override
    @RequiresApi(api=26)
    public void configureChannel(NotificationChannel notificationChannel) {
        NotificationChannel notificationChannel2 = notificationChannel;
        notificationChannel.setImportance(4);
        notificationChannel2.setDescription(this.getString(R.string.echat_default_notification_description));
        notificationChannel2.setLightColor(-16711936);
        notificationChannel2.enableLights(true);
        notificationChannel2.enableVibration(true);
        notificationChannel2.setShowBadge(true);
        notificationChannel2.setLockscreenVisibility(1);
        notificationChannel2.setSound(RingtoneManager.getDefaultUri((int)2), new AudioAttributes.Builder().setUsage(5).setContentType(1).build());
    }

    public EChatNotification setBigIcon(Bitmap bitmap) {
        this.bitIcon = bitmap;
        return this;
    }

    public EChatNotification clearHistoryMessages() {
        List<EChatPushData> list = this.internalPushMessages;
        if (list != null) {
            list.clear();
        }
        return this;
    }

    public void cancel() {
        this.manager.cancel(((EChatPushData)this.getData()).getCompanyId().intValue());
    }
}

