/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import rp.com.google.common.collect.Sets;

public class TagsParser {
    public static final String BUILD_TAG = "build";
    public static final String BUILD_MARKER = "build:";

    public static Map<String, String> findAllTags(String rawTags) {
        if (rawTags == null) {
            return null;
        }
        return TagsParser.parseTags(rawTags);
    }

    public static Set<String> parseAsSet(String rawTags) {
        if (null == rawTags) {
            return null;
        }
        return Sets.newHashSet(rawTags.trim().split(";"));
    }

    private static Map<String, String> parseTags(String rawTags) {
        String[] splitRawTags;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String tag : splitRawTags = rawTags.trim().split(";")) {
            if (TagsParser.isBuildTag(tag)) {
                result.put(BUILD_TAG, tag.substring(BUILD_MARKER.length()));
                continue;
            }
            if (tag.trim().isEmpty()) continue;
            result.put(tag, tag);
        }
        return result;
    }

    private static boolean isBuildTag(String tag) {
        return BUILD_MARKER.length() <= tag.length() && BUILD_MARKER.equalsIgnoreCase(tag.substring(0, BUILD_MARKER.length()));
    }
}

