/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.launch;

import com.epam.ta.reportportal.ws.annotations.NotEmpty;
import com.epam.ta.reportportal.ws.model.OwnedResource;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.statistics.Statistics;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LaunchResource
extends OwnedResource {
    @NotNull
    @JsonProperty(value="id", required=true)
    private String launchId;
    @NotNull
    @NotEmpty
    @Size(min=3, max=256)
    @JsonProperty(value="name", required=true)
    private String name;
    @NotNull
    @JsonProperty(value="number", required=true)
    private Long number;
    @JsonProperty(value="description")
    @Size(min=0, max=1024)
    private String description;
    @NotNull
    @JsonProperty(value="start_time", required=true)
    private Date startTime;
    @JsonProperty(value="end_time")
    private Date endTime;
    @NotNull
    @JsonProperty(value="status", required=true)
    private String status;
    @JsonProperty(value="statistics")
    @Valid
    private Statistics statistics;
    @JsonProperty(value="tags")
    private Set<String> tags;
    @JsonProperty(value="mode")
    private Mode mode;
    @JsonProperty(value="isProcessing")
    private boolean isProcessing;
    @JsonProperty(value="approximateDuration")
    private double approximateDuration;

    public double getApproximateDuration() {
        return this.approximateDuration;
    }

    public void setApproximateDuration(double approximateDuration) {
        this.approximateDuration = approximateDuration;
    }

    public String getLaunchId() {
        return this.launchId;
    }

    public void setLaunchId(String launchId) {
        this.launchId = launchId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getNumber() {
        return this.number;
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setIsProcessing(boolean is) {
        this.isProcessing = is;
    }

    public boolean getIsProcessing() {
        return this.isProcessing;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LaunchResource{");
        sb.append("launchId='").append(this.launchId).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", number=").append(this.number);
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", startTime=").append(this.startTime);
        sb.append(", endTime=").append(this.endTime);
        sb.append(", status='").append(this.status).append('\'');
        sb.append(", statistics=").append(this.statistics);
        sb.append(", tags=").append(this.tags);
        sb.append(", mode=").append((Object)this.mode);
        sb.append('}');
        return sb.toString();
    }
}

