/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.user;

import com.epam.ta.reportportal.ws.annotations.NotEmpty;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateUserRQFull {
    @NotNull
    @Pattern(regexp="[a-zA-Z0-9-_.]+")
    @Size(min=1, max=128)
    @JsonProperty(value="login", required=true)
    @ApiModelProperty(required=true)
    private String login;
    @NotNull
    @NotEmpty
    @Size(min=4, max=25)
    @JsonProperty(value="password", required=true)
    @ApiModelProperty(required=true)
    private String password;
    @NotNull
    @NotEmpty
    @Pattern(regexp="[\\pL0-9-_ \\.]+")
    @Size(min=3, max=256)
    @JsonProperty(value="full_name", required=true)
    @ApiModelProperty(required=true)
    private String fullName;
    @NotNull
    @NotEmpty
    @JsonProperty(value="email", required=true)
    @ApiModelProperty(required=true)
    private String email;
    @NotNull
    @JsonProperty(value="accountRole", required=true)
    @ApiModelProperty(required=true, allowableValues="USER, ADMINISTRATOR")
    private String accountRole;
    @NotNull
    @JsonProperty(value="projectRole", required=true)
    @ApiModelProperty(required=true, allowableValues="CUSTOMER, MEMBER, LEAD, PROJECT_MANAGER")
    private String projectRole;
    @NotNull
    @JsonProperty(value="default_project", required=true)
    @ApiModelProperty(required=true)
    private String defaultProject;

    public void setLogin(String value) {
        this.login = value;
    }

    public String getLogin() {
        return this.login;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setFullName(String value) {
        this.fullName = value;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAccountRole() {
        return this.accountRole;
    }

    public void setAccountRole(String role) {
        this.accountRole = role;
    }

    public String getProjectRole() {
        return this.projectRole;
    }

    public void setProjectRole(String role) {
        this.projectRole = role;
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(String value) {
        this.defaultProject = value;
    }

    public String toString() {
        return "CreateUserRQFull [login=" + this.login + ", password=" + this.password + ", fullName=" + this.fullName + ", email=" + this.email + ", projectRole=" + this.projectRole + ", defaultProject=" + this.defaultProject + "]";
    }
}

