/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.components.DraweeEventTracker;
import com.facebook.drawee.drawable.VisibilityAwareDrawable;
import com.facebook.drawee.drawable.VisibilityCallback;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import javax.annotation.Nullable;

public class DraweeHolder<DH extends DraweeHierarchy>
implements VisibilityCallback {
    private boolean mIsControllerAttached = false;
    private boolean mIsHolderAttached = false;
    private boolean mIsVisible = true;
    @Nullable
    private DH mHierarchy;
    private DraweeController mController = null;
    private final DraweeEventTracker mEventTracker = DraweeEventTracker.newInstance();

    public static <DH extends DraweeHierarchy> DraweeHolder<DH> create(@Nullable DH hierarchy, Context context) {
        DraweeHolder<DH> holder = new DraweeHolder<DH>(hierarchy);
        holder.registerWithContext(context);
        return holder;
    }

    public void registerWithContext(Context context) {
    }

    public DraweeHolder(@Nullable DH hierarchy) {
        if (hierarchy != null) {
            this.setHierarchy(hierarchy);
        }
    }

    public void onAttach() {
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_HOLDER_ATTACH);
        this.mIsHolderAttached = true;
        this.attachOrDetachController();
    }

    public boolean isAttached() {
        return this.mIsHolderAttached;
    }

    public void onDetach() {
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_HOLDER_DETACH);
        this.mIsHolderAttached = false;
        this.attachOrDetachController();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isControllerValid()) {
            return false;
        }
        return this.mController.onTouchEvent(event);
    }

    @Override
    public void onVisibilityChange(boolean isVisible) {
        if (this.mIsVisible == isVisible) {
            return;
        }
        this.mEventTracker.recordEvent(isVisible ? DraweeEventTracker.Event.ON_DRAWABLE_SHOW : DraweeEventTracker.Event.ON_DRAWABLE_HIDE);
        this.mIsVisible = isVisible;
        this.attachOrDetachController();
    }

    @Override
    public void onDraw() {
        if (this.mIsControllerAttached) {
            return;
        }
        FLog.w(DraweeEventTracker.class, (String)"%x: Draw requested for a non-attached controller %x. %s", (Object[])new Object[]{System.identityHashCode(this), System.identityHashCode(this.mController), this.toString()});
        this.mIsHolderAttached = true;
        this.mIsVisible = true;
        this.attachOrDetachController();
    }

    private void setVisibilityCallback(@Nullable VisibilityCallback visibilityCallback) {
        Drawable drawable = this.getTopLevelDrawable();
        if (drawable instanceof VisibilityAwareDrawable) {
            ((VisibilityAwareDrawable)drawable).setVisibilityCallback(visibilityCallback);
        }
    }

    public void setController(@Nullable DraweeController draweeController) {
        boolean wasAttached = this.mIsControllerAttached;
        if (wasAttached) {
            this.detachController();
        }
        if (this.isControllerValid()) {
            this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_CLEAR_OLD_CONTROLLER);
            this.mController.setHierarchy(null);
        }
        this.mController = draweeController;
        if (this.mController != null) {
            this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_SET_CONTROLLER);
            this.mController.setHierarchy((DraweeHierarchy)this.mHierarchy);
        } else {
            this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_CLEAR_CONTROLLER);
        }
        if (wasAttached) {
            this.attachController();
        }
    }

    @Nullable
    public DraweeController getController() {
        return this.mController;
    }

    public void setHierarchy(DH hierarchy) {
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_SET_HIERARCHY);
        boolean isControllerValid = this.isControllerValid();
        this.setVisibilityCallback(null);
        this.mHierarchy = (DraweeHierarchy)Preconditions.checkNotNull(hierarchy);
        Drawable drawable = this.mHierarchy.getTopLevelDrawable();
        this.onVisibilityChange(drawable == null || drawable.isVisible());
        this.setVisibilityCallback(this);
        if (isControllerValid) {
            this.mController.setHierarchy((DraweeHierarchy)hierarchy);
        }
    }

    public DH getHierarchy() {
        return (DH)((DraweeHierarchy)Preconditions.checkNotNull(this.mHierarchy));
    }

    public boolean hasHierarchy() {
        return this.mHierarchy != null;
    }

    @Nullable
    public Drawable getTopLevelDrawable() {
        return this.mHierarchy == null ? null : this.mHierarchy.getTopLevelDrawable();
    }

    public boolean isControllerValid() {
        return this.mController != null && this.mController.getHierarchy() == this.mHierarchy;
    }

    protected DraweeEventTracker getDraweeEventTracker() {
        return this.mEventTracker;
    }

    private void attachController() {
        if (this.mIsControllerAttached) {
            return;
        }
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_ATTACH_CONTROLLER);
        this.mIsControllerAttached = true;
        if (this.mController != null && this.mController.getHierarchy() != null) {
            this.mController.onAttach();
        }
    }

    private void detachController() {
        if (!this.mIsControllerAttached) {
            return;
        }
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_DETACH_CONTROLLER);
        this.mIsControllerAttached = false;
        if (this.isControllerValid()) {
            this.mController.onDetach();
        }
    }

    private void attachOrDetachController() {
        if (this.mIsHolderAttached && this.mIsVisible) {
            this.attachController();
        } else {
            this.detachController();
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("controllerAttached", this.mIsControllerAttached).add("holderAttached", this.mIsHolderAttached).add("drawableVisible", this.mIsVisible).add("events", (Object)this.mEventTracker.toString()).toString();
    }
}

