/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.view;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class MultiDraweeHolder<DH extends DraweeHierarchy> {
    @VisibleForTesting
    boolean mIsAttached = false;
    @VisibleForTesting
    ArrayList<DraweeHolder<DH>> mHolders = new ArrayList();

    public void onAttach() {
        if (this.mIsAttached) {
            return;
        }
        this.mIsAttached = true;
        for (int i = 0; i < this.mHolders.size(); ++i) {
            this.mHolders.get(i).onAttach();
        }
    }

    public void onDetach() {
        if (!this.mIsAttached) {
            return;
        }
        this.mIsAttached = false;
        for (int i = 0; i < this.mHolders.size(); ++i) {
            this.mHolders.get(i).onDetach();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        for (int i = 0; i < this.mHolders.size(); ++i) {
            if (!this.mHolders.get(i).onTouchEvent(event)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.mIsAttached) {
            for (int i = 0; i < this.mHolders.size(); ++i) {
                this.mHolders.get(i).onDetach();
            }
        }
        this.mHolders.clear();
    }

    public void add(DraweeHolder<DH> holder) {
        this.add(this.mHolders.size(), holder);
    }

    public void add(int index, DraweeHolder<DH> holder) {
        Preconditions.checkNotNull(holder);
        Preconditions.checkElementIndex((int)index, (int)(this.mHolders.size() + 1));
        this.mHolders.add(index, holder);
        if (this.mIsAttached) {
            holder.onAttach();
        }
    }

    public void remove(int index) {
        DraweeHolder<DH> holder = this.mHolders.get(index);
        if (this.mIsAttached) {
            holder.onDetach();
        }
        this.mHolders.remove(index);
    }

    public DraweeHolder<DH> get(int index) {
        return this.mHolders.get(index);
    }

    public int size() {
        return this.mHolders.size();
    }

    public void draw(Canvas canvas) {
        for (int i = 0; i < this.mHolders.size(); ++i) {
            Drawable drawable = this.get(i).getTopLevelDrawable();
            if (drawable == null) continue;
            drawable.draw(canvas);
        }
    }

    public boolean verifyDrawable(Drawable who) {
        for (int i = 0; i < this.mHolders.size(); ++i) {
            if (who != this.get(i).getTopLevelDrawable()) continue;
            return true;
        }
        return false;
    }
}

