/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif.parsers;

import be.teletask.onvif.models.OnvifStatus;
import be.teletask.onvif.parsers.OnvifParser;
import be.teletask.onvif.responses.OnvifResponse;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParserException;

public class GetStatusParser
extends OnvifParser<OnvifStatus> {
    public static final String TAG = GetStatusParser.class.getSimpleName();
    private static final String KEY_POSITION = "Position";
    private static final String KEY_POSITION_PANTILT = "PanTilt";
    private static final String KEY_POSITION_ZOOM = "Zoom";

    @Override
    public OnvifStatus parse(OnvifResponse response) {
        OnvifStatus status = new OnvifStatus();
        try {
            this.getXpp().setInput((Reader)new StringReader(response.getXml()));
            this.eventType = this.getXpp().getEventType();
            while (this.eventType != 1) {
                int i;
                if (this.eventType == 2 && this.getXpp().getName().equals(KEY_POSITION_PANTILT)) {
                    for (i = 0; i < this.getXpp().getAttributeCount(); ++i) {
                        if (this.getXpp().getAttributeName(i).equals("x")) {
                            status.setPan(Double.valueOf(this.getXpp().getAttributeValue(i)));
                            continue;
                        }
                        if (!this.getXpp().getAttributeName(i).equals("y")) continue;
                        status.setTilt(Double.valueOf(this.getXpp().getAttributeValue(i)));
                    }
                } else if (this.eventType == 2 && this.getXpp().getName().equals(KEY_POSITION_ZOOM)) {
                    for (i = 0; i < this.getXpp().getAttributeCount(); ++i) {
                        if (!this.getXpp().getAttributeName(i).equals("x")) continue;
                        status.setZoom(Double.valueOf(this.getXpp().getAttributeValue(i)));
                    }
                } else if (this.eventType == 3 && this.getXpp().getName().equals(KEY_POSITION)) {
                    return status;
                }
                this.eventType = this.getXpp().next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        return null;
    }
}

