/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.configuration;

import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.jcache.copy.Copier;
import com.github.benmanes.caffeine.jcache.copy.JavaSerializationCopier;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CaffeineConfiguration<K, V>
implements CompleteConfiguration<K, V> {
    private static final Factory<Scheduler> DISABLED_SCHEDULER = Scheduler::disabledScheduler;
    private static final Factory<Copier> JAVA_COPIER = JavaSerializationCopier::new;
    private static final Factory<Executor> COMMON_POOL = ForkJoinPool::commonPool;
    private static final Factory<Ticker> SYSTEM_TICKER = Ticker::systemTicker;
    private static final long serialVersionUID = 1L;
    private final MutableConfiguration<K, V> delegate;
    private final boolean readOnly;
    private @Nullable Factory<Weigher<K, V>> weigherFactory;
    private @Nullable Factory<Expiry<K, V>> expiryFactory;
    private Factory<Scheduler> schedulerFactory;
    private Factory<Executor> executorFactory;
    private Factory<Copier> copierFactory;
    private Factory<Ticker> tickerFactory;
    private @Nullable Long refreshAfterWriteNanos;
    private @Nullable Long expireAfterAccessNanos;
    private @Nullable Long expireAfterWriteNanos;
    private @Nullable Long maximumWeight;
    private @Nullable Long maximumSize;
    private boolean nativeStatistics;

    public CaffeineConfiguration() {
        this.delegate = new MutableConfiguration();
        this.delegate.setStoreByValue(false);
        this.schedulerFactory = DISABLED_SCHEDULER;
        this.tickerFactory = SYSTEM_TICKER;
        this.executorFactory = COMMON_POOL;
        this.copierFactory = JAVA_COPIER;
        this.readOnly = false;
    }

    public CaffeineConfiguration(CompleteConfiguration<K, V> configuration) {
        this(configuration, false);
    }

    private CaffeineConfiguration(CompleteConfiguration<K, V> configuration, boolean readOnly) {
        this.delegate = new MutableConfiguration(configuration);
        if (configuration instanceof CaffeineConfiguration) {
            CaffeineConfiguration config = (CaffeineConfiguration)configuration;
            this.refreshAfterWriteNanos = config.refreshAfterWriteNanos;
            this.expireAfterAccessNanos = config.expireAfterAccessNanos;
            this.expireAfterWriteNanos = config.expireAfterWriteNanos;
            this.nativeStatistics = config.nativeStatistics;
            this.schedulerFactory = config.schedulerFactory;
            this.executorFactory = config.executorFactory;
            this.expiryFactory = config.expiryFactory;
            this.copierFactory = config.copierFactory;
            this.tickerFactory = config.tickerFactory;
            this.weigherFactory = config.weigherFactory;
            this.maximumWeight = config.maximumWeight;
            this.maximumSize = config.maximumSize;
        } else {
            this.schedulerFactory = DISABLED_SCHEDULER;
            this.tickerFactory = SYSTEM_TICKER;
            this.executorFactory = COMMON_POOL;
            this.copierFactory = JAVA_COPIER;
        }
        this.readOnly = readOnly;
    }

    public CaffeineConfiguration<K, V> immutableCopy() {
        return new CaffeineConfiguration<K, V>(this, true);
    }

    private void checkIfReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    public Class<K> getKeyType() {
        return this.delegate.getKeyType();
    }

    public Class<V> getValueType() {
        return this.delegate.getValueType();
    }

    public void setTypes(Class<K> keyType, Class<V> valueType) {
        this.checkIfReadOnly();
        this.delegate.setTypes(keyType, valueType);
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return new UnmodifiableIterable<CacheEntryListenerConfiguration<K, V>>(this.delegate.getCacheEntryListenerConfigurations());
    }

    public void addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.checkIfReadOnly();
        this.delegate.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public void removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.checkIfReadOnly();
        this.delegate.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.delegate.getCacheLoaderFactory();
    }

    public void setCacheLoaderFactory(Factory<? extends CacheLoader<K, V>> factory) {
        this.checkIfReadOnly();
        this.delegate.setCacheLoaderFactory(factory);
    }

    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.delegate.getCacheWriterFactory();
    }

    public @Nullable CacheWriter<K, V> getCacheWriter() {
        if (this.hasCacheWriter()) {
            CacheWriter writer = (CacheWriter)this.getCacheWriterFactory().create();
            return writer;
        }
        return null;
    }

    public boolean hasCacheWriter() {
        return this.getCacheWriterFactory() != null;
    }

    public void setCacheWriterFactory(Factory<? extends CacheWriter<? super K, ? super V>> factory) {
        this.checkIfReadOnly();
        this.delegate.setCacheWriterFactory(factory);
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.delegate.getExpiryPolicyFactory();
    }

    public void setExpiryPolicyFactory(Factory<? extends ExpiryPolicy> factory) {
        this.checkIfReadOnly();
        this.delegate.setExpiryPolicyFactory(factory);
    }

    public boolean isReadThrough() {
        return this.delegate.isReadThrough();
    }

    public void setReadThrough(boolean isReadThrough) {
        this.checkIfReadOnly();
        this.delegate.setReadThrough(isReadThrough);
    }

    public boolean isWriteThrough() {
        return this.delegate.isWriteThrough();
    }

    public void setWriteThrough(boolean isWriteThrough) {
        this.checkIfReadOnly();
        this.delegate.setWriteThrough(isWriteThrough);
    }

    public boolean isStoreByValue() {
        return this.delegate.isStoreByValue();
    }

    public void setStoreByValue(boolean isStoreByValue) {
        this.checkIfReadOnly();
        this.delegate.setStoreByValue(isStoreByValue);
    }

    public boolean isNativeStatisticsEnabled() {
        return this.nativeStatistics;
    }

    public void setNativeStatisticsEnabled(boolean enabled) {
        this.checkIfReadOnly();
        this.nativeStatistics = enabled;
    }

    public boolean isStatisticsEnabled() {
        return this.delegate.isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.checkIfReadOnly();
        this.delegate.setStatisticsEnabled(enabled);
    }

    public boolean isManagementEnabled() {
        return this.delegate.isManagementEnabled();
    }

    public void setManagementEnabled(boolean enabled) {
        this.checkIfReadOnly();
        this.delegate.setManagementEnabled(enabled);
    }

    public Factory<Copier> getCopierFactory() {
        return this.copierFactory;
    }

    public void setCopierFactory(Factory<Copier> factory) {
        this.checkIfReadOnly();
        this.copierFactory = Objects.requireNonNull(factory);
    }

    public Factory<Scheduler> getSchedulerFactory() {
        return this.schedulerFactory;
    }

    public void setSchedulerFactory(Factory<Scheduler> factory) {
        this.checkIfReadOnly();
        this.schedulerFactory = Objects.requireNonNull(factory);
    }

    public Factory<Ticker> getTickerFactory() {
        return this.tickerFactory;
    }

    public void setTickerFactory(Factory<Ticker> factory) {
        this.checkIfReadOnly();
        this.tickerFactory = Objects.requireNonNull(factory);
    }

    public Factory<Executor> getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(Factory<Executor> factory) {
        this.checkIfReadOnly();
        this.executorFactory = Objects.requireNonNull(factory);
    }

    public OptionalLong getRefreshAfterWrite() {
        return this.refreshAfterWriteNanos == null ? OptionalLong.empty() : OptionalLong.of(this.refreshAfterWriteNanos);
    }

    public void setRefreshAfterWrite(OptionalLong refreshAfterWriteNanos) {
        this.checkIfReadOnly();
        this.refreshAfterWriteNanos = refreshAfterWriteNanos.isPresent() ? Long.valueOf(refreshAfterWriteNanos.getAsLong()) : null;
    }

    public OptionalLong getExpireAfterWrite() {
        return this.expireAfterWriteNanos == null ? OptionalLong.empty() : OptionalLong.of(this.expireAfterWriteNanos);
    }

    public void setExpireAfterWrite(OptionalLong expireAfterWriteNanos) {
        this.checkIfReadOnly();
        this.expireAfterWriteNanos = expireAfterWriteNanos.isPresent() ? Long.valueOf(expireAfterWriteNanos.getAsLong()) : null;
    }

    public OptionalLong getExpireAfterAccess() {
        return this.expireAfterAccessNanos == null ? OptionalLong.empty() : OptionalLong.of(this.expireAfterAccessNanos);
    }

    public void setExpireAfterAccess(OptionalLong expireAfterAccessNanos) {
        this.checkIfReadOnly();
        this.expireAfterAccessNanos = expireAfterAccessNanos.isPresent() ? Long.valueOf(expireAfterAccessNanos.getAsLong()) : null;
    }

    public Optional<Factory<Expiry<K, V>>> getExpiryFactory() {
        return Optional.ofNullable(this.expiryFactory);
    }

    public void setExpiryFactory(Optional<Factory<? extends Expiry<K, V>>> factory) {
        this.checkIfReadOnly();
        this.expiryFactory = factory.orElse(null);
    }

    public void setMaximumSize(OptionalLong maximumSize) {
        this.checkIfReadOnly();
        this.maximumSize = maximumSize.isPresent() ? Long.valueOf(maximumSize.getAsLong()) : null;
    }

    public OptionalLong getMaximumSize() {
        return this.maximumSize == null ? OptionalLong.empty() : OptionalLong.of(this.maximumSize);
    }

    public void setMaximumWeight(OptionalLong maximumWeight) {
        this.checkIfReadOnly();
        this.maximumWeight = maximumWeight.isPresent() ? Long.valueOf(maximumWeight.getAsLong()) : null;
    }

    public OptionalLong getMaximumWeight() {
        return this.maximumWeight == null ? OptionalLong.empty() : OptionalLong.of(this.maximumWeight);
    }

    public Optional<Factory<Weigher<K, V>>> getWeigherFactory() {
        return Optional.ofNullable(this.weigherFactory);
    }

    public void setWeigherFactory(Optional<Factory<? extends Weigher<K, V>>> factory) {
        this.checkIfReadOnly();
        this.weigherFactory = factory.orElse(null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaffeineConfiguration)) {
            return false;
        }
        CaffeineConfiguration config = (CaffeineConfiguration)o;
        return Objects.equals(this.refreshAfterWriteNanos, config.refreshAfterWriteNanos) && Objects.equals(this.expireAfterAccessNanos, config.expireAfterAccessNanos) && Objects.equals(this.expireAfterWriteNanos, config.expireAfterWriteNanos) && Objects.equals(this.executorFactory, config.executorFactory) && Objects.equals(this.copierFactory, config.copierFactory) && Objects.equals(this.tickerFactory, config.tickerFactory) && Objects.equals(this.weigherFactory, config.weigherFactory) && Objects.equals(this.maximumWeight, config.maximumWeight) && Objects.equals(this.maximumSize, config.maximumSize) && this.delegate.equals(config.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private static final class UnmodifiableIterable<E>
    implements Iterable<E> {
        private final Iterable<E> delegate;

        private UnmodifiableIterable(Iterable<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> iterator = this.delegate.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    return iterator.next();
                }
            };
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.delegate.spliterator();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

