/*
 * Decompiled with CFR 0.152.
 */
package fr.castorflex.android.circularprogressbar;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import fr.castorflex.android.circularprogressbar.CircularProgressDrawable;
import fr.castorflex.android.circularprogressbar.PBDelegate;
import java.util.concurrent.TimeUnit;

public class PowerSaveModeDelegate
implements PBDelegate {
    private static final long REFRESH_RATE = TimeUnit.SECONDS.toMillis(1L);
    private final CircularProgressDrawable mParent;
    private int mCurrentRotation;
    private final Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            PowerSaveModeDelegate.this.mCurrentRotation = PowerSaveModeDelegate.this.mCurrentRotation + 50;
            PowerSaveModeDelegate.this.mCurrentRotation = PowerSaveModeDelegate.this.mCurrentRotation % 360;
            if (PowerSaveModeDelegate.this.mParent.isRunning()) {
                PowerSaveModeDelegate.this.mParent.scheduleSelf(this, SystemClock.uptimeMillis() + REFRESH_RATE);
            }
            PowerSaveModeDelegate.this.mParent.invalidate();
        }
    };

    public PowerSaveModeDelegate(@NonNull CircularProgressDrawable parent) {
        this.mParent = parent;
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        canvas.drawArc(this.mParent.getDrawableBounds(), (float)this.mCurrentRotation, 300.0f, false, paint);
    }

    @Override
    public void start() {
        this.mParent.invalidate();
        this.mParent.scheduleSelf(this.mRunnable, SystemClock.uptimeMillis() + REFRESH_RATE);
    }

    @Override
    public void stop() {
        this.mParent.unscheduleSelf(this.mRunnable);
    }

    @Override
    public void progressiveStop(CircularProgressDrawable.OnEndListener listener) {
        this.mParent.stop();
    }
}

