/*
 * Decompiled with CFR 0.152.
 */
package space.fei.code.onvif.discovery;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import space.fei.code.onvif.diagnostics.logging.Logger;
import space.fei.code.onvif.diagnostics.logging.Loggers;
import space.fei.code.onvif.model.OnvifDeviceInfo;
import space.fei.code.onvif.util.NetworkUtils;
import space.fei.code.onvif.util.RegexUtils;
import space.fei.code.onvif.util.XMLUtils;

public class IPCDiscovery {
    private static final Logger LOGGER = Loggers.getLogger(IPCDiscovery.class);
    private static final String MULTICAST_IP = "239.255.255.250";
    private static final Integer MULTICAST_PORT = 3702;
    private static final int SOCKET_TIMEOUT_MILL_SECONDS = 1000;
    private static final int DISCOVERY_TIMEOUT_MILL_SECONDS = 3000;
    private static final String SOAP_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<e:Envelope xmlns:e=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:w=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" \n\txmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" xmlns:dn=\"http://www.onvif.org/ver10/network/wsdl\">\n\t<e:Header>\n\t\t<w:MessageID>uuid:" + UUID.randomUUID().toString() + "</w:MessageID>\n\t\t\t<w:To e:mustUnderstand=\"true\">urn:schemas-xmlsoap-org:ws:2005:04:discovery</w:To>\n\t\t\t<w:Action a:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2005/04/discovery/Probe</w:Action>\n\t</e:Header>\n\t<e:Body>\n\t\t<d:Probe>\n\t\t\t<d:Types>dn:NetworkVideoTransmitter</d:Types>\n\t\t</d:Probe>\n\t</e:Body>\n</e:Envelope>";

    private static MulticastSocket createMulticastGroupAndJoin(String groupUrl, int port, String localIp) {
        try {
            InetAddress group = InetAddress.getByName(groupUrl);
            MulticastSocket socket = new MulticastSocket(port);
            socket.setNetworkInterface(NetworkInterface.getByInetAddress(InetAddress.getByName(localIp)));
            socket.setSoTimeout(1000);
            socket.joinGroup(group);
            return socket;
        }
        catch (Exception e1) {
            LOGGER.warn("createMulticastGroupAndJoin----->>>>Error: {}", e1);
            return null;
        }
    }

    private static void sendData(MulticastSocket socket, byte[] data, String groupUrl, int port) {
        try {
            InetAddress group = InetAddress.getByName(groupUrl);
            DatagramPacket packet = new DatagramPacket(data, data.length, group, port);
            socket.send(packet);
        }
        catch (Exception e1) {
            LOGGER.error("sendData------>>>>>Error: {}", e1);
        }
    }

    private static String receiveData(MulticastSocket socket, String groupUrl, int port) {
        String message;
        try {
            InetAddress group = InetAddress.getByName(groupUrl);
            byte[] data = new byte[2048];
            DatagramPacket packet = new DatagramPacket(data, data.length, group, port);
            socket.receive(packet);
            message = new String(packet.getData());
        }
        catch (Exception e) {
            return "";
        }
        return message;
    }

    public static List<OnvifDeviceInfo> discovery(String localIp) throws Exception {
        if (StringUtils.isEmpty((CharSequence)localIp) || !RegexUtils.isIp(localIp)) {
            throw new Exception("\u4e0d\u6b63\u786e\u7684IP--" + localIp);
        }
        return IPCDiscovery.start(localIp);
    }

    public static List<OnvifDeviceInfo> discovery() throws Exception {
        return IPCDiscovery.start("");
    }

    private static List<OnvifDeviceInfo> start(String localIp) throws Exception {
        String message;
        Random random = new Random();
        int port = random.nextInt(64512) + 1024;
        if (StringUtils.isEmpty((CharSequence)localIp)) {
            localIp = NetworkUtils.getLocalHostLANAddress().getHostAddress();
            LOGGER.debug("discovery ipc use ip [" + localIp + "]");
        }
        MulticastSocket socket = IPCDiscovery.createMulticastGroupAndJoin(MULTICAST_IP, port, localIp);
        IPCDiscovery.sendData(socket, SOAP_CONTENT.getBytes(), MULTICAST_IP, MULTICAST_PORT);
        ArrayList<String> receiveDataList = new ArrayList<String>();
        long startTime = System.currentTimeMillis();
        while (!StringUtils.isEmpty((CharSequence)(message = IPCDiscovery.receiveData(socket, MULTICAST_IP, MULTICAST_PORT)))) {
            LOGGER.debug(message);
            receiveDataList.add(message);
            if (System.currentTimeMillis() - startTime <= 3000L) continue;
            break;
        }
        ArrayList<OnvifDeviceInfo> onvifDeviceInfoList = new ArrayList<OnvifDeviceInfo>();
        for (String onvifMessage : receiveDataList) {
            OnvifDeviceInfo onvifDeviceInfo = new OnvifDeviceInfo();
            try {
                String onvifAddress = XMLUtils.parseOnvifAddress(onvifMessage);
                onvifDeviceInfo.setOnvifAddress(onvifAddress);
                onvifDeviceInfo.setIp(RegexUtils.extractIpFromString(onvifAddress));
            }
            catch (Exception e) {
                LOGGER.info("\u89e3\u6790\u5730\u5740[" + onvifMessage + "]\u51fa\u9519, " + ExceptionUtils.getStackTrace((Throwable)e));
                onvifDeviceInfo.setOnvifAddress("");
                onvifDeviceInfo.setIp("");
            }
            onvifDeviceInfoList.add(onvifDeviceInfo);
        }
        return onvifDeviceInfoList;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(IPCDiscovery.discovery("192.168.101.47"));
    }
}

