/*
 * Decompiled with CFR 0.152.
 */
package space.fei.code.onvif.discovery;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import space.fei.code.onvif.diagnostics.logging.Logger;
import space.fei.code.onvif.diagnostics.logging.Loggers;
import space.fei.code.onvif.model.OnvifDeviceInfo;
import space.fei.code.onvif.util.RegexUtils;
import space.fei.code.onvif.util.XMLUtils;

public class SingleIPCDiscovery {
    private static final Logger LOGGER = Loggers.getLogger(SingleIPCDiscovery.class);
    private static final int TIMEOUT = 3000;
    private static final int MAXNUM = 2;
    private static final String SOAP_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><e:Envelope xmlns:e=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:w=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"    xmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" xmlns:dn=\"http://www.onvif.org/ver10/network/wsdl\">   <e:Header>       <w:MessageID>           uuid:" + UUID.randomUUID().toString() + "       </w:MessageID>       <w:To e:mustUnderstand=\"true\">urn:schemas-xmlsoap-org:ws:2005:04:discovery</w:To>       <w:Action a:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2005/04/discovery/Probe</w:Action>   </e:Header>   <e:Body>   <d:Probe>       <d:Types>dn:NetworkVideoTransmitter</d:Types>   </d:Probe>   </e:Body></e:Envelope>";

    private static String getOnvifAddressByIp(String ip) throws Exception {
        byte[] buf = new byte[10240];
        Random random = new Random();
        DatagramSocket ds = new DatagramSocket(random.nextInt(64512) + 1024);
        InetAddress ipcIp = InetAddress.getByName(ip);
        DatagramPacket dpSend = new DatagramPacket(SOAP_CONTENT.getBytes(), SOAP_CONTENT.length(), ipcIp, 3702);
        DatagramPacket dpReceive = new DatagramPacket(buf, 10240);
        ds.setSoTimeout(3000);
        int tries = 0;
        boolean receivedResponse = false;
        while (!receivedResponse && tries < 2) {
            ds.send(dpSend);
            try {
                ds.receive(dpReceive);
                if (!dpReceive.getAddress().equals(ipcIp)) {
                    throw new IOException("Received packet from an umknown source");
                }
                receivedResponse = true;
            }
            catch (InterruptedIOException e) {
                LOGGER.debug("Time out, " + (2 - ++tries) + " more tries...");
            }
        }
        String receiveContent = "";
        if (receivedResponse) {
            receiveContent = new String(dpReceive.getData(), 0, dpReceive.getLength());
        } else {
            LOGGER.debug("No response -- give up.");
        }
        ds.close();
        return receiveContent;
    }

    public static void fillOnvifAddress(OnvifDeviceInfo onvifDeviceInfo) throws Exception {
        if (StringUtils.isEmpty((CharSequence)onvifDeviceInfo.getIp()) || !RegexUtils.isIp(onvifDeviceInfo.getIp())) {
            throw new RuntimeException("onvif \u8bbe\u5907\u7684ip\u4e0d\u5408\u6cd5");
        }
        String onvifAddress = null;
        String xmlContent = SingleIPCDiscovery.getOnvifAddressByIp(onvifDeviceInfo.getIp());
        String onvifAddressAll = XMLUtils.parseOnvifAddress(xmlContent);
        onvifAddress = onvifAddressAll.trim().split(" ")[0];
        onvifDeviceInfo.setOnvifAddress(onvifAddress);
    }

    public static String probeOnvifByIp(String ip) throws Exception {
        if (StringUtils.isEmpty((CharSequence)ip) || !RegexUtils.isIp(ip)) {
            throw new Exception("\u4e0d\u6b63\u786e\u7684IP--" + ip);
        }
        return XMLUtils.parseOnvifAddress(SingleIPCDiscovery.getOnvifAddressByIp(ip));
    }
}

