/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.model;

import java.io.IOException;
import java.util.stream.Stream;
import redis.embedded.error.OsArchitectureNotFound;
import redis.embedded.util.IO;

public enum Architecture {
    x86,
    x86_64,
    aarch64;


    public static Architecture detectWindowsArchitecture() {
        String wow64Arch;
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        return Architecture.isWindows64Bit(arch, wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432")) ? x86_64 : x86;
    }

    public static Architecture detectUnixMacOSXArchitecture() {
        Architecture architecture;
        block8: {
            Stream<String> lines = IO.processToLines("uname -m");
            try {
                architecture = lines.filter(Architecture::isUnix64Bit).map(line -> line.contains("aarch64") || line.contains("arm64") ? aarch64 : x86_64).findFirst().orElse(x86);
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OsArchitectureNotFound(e);
                }
            }
            lines.close();
        }
        return architecture;
    }

    private static boolean isWindows64Bit(String arch, String wow64Arch) {
        return arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64");
    }

    private static boolean isUnix64Bit(String line) {
        return !line.isEmpty() && line.contains("64");
    }
}

