/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.model;

import java.util.function.Supplier;
import redis.embedded.error.UnknownOSName;
import redis.embedded.model.Architecture;

public enum OS {
    WINDOWS(Architecture::detectWindowsArchitecture),
    UNIX(Architecture::detectUnixMacOSXArchitecture),
    MAC_OS_X(Architecture::detectUnixMacOSXArchitecture);

    private final Supplier<Architecture> archSupplier;

    private OS(Supplier<Architecture> archSupplier) {
        this.archSupplier = archSupplier;
    }

    public Architecture detectArchitecture() {
        return this.archSupplier.get();
    }

    public static OS detectOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return UNIX;
        }
        if ("Mac OS X".equalsIgnoreCase(osName)) {
            return MAC_OS_X;
        }
        throw new UnknownOSName(osName);
    }
}

