/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.FileRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.Formatter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;

public class JsonRenderer
extends FileRenderer {
    private String template;
    protected StringBuilder json = new StringBuilder();
    private final boolean fullGitMessage;
    private boolean firstCommit = true;
    private Collection<RevTag> tags = new ArrayList<RevTag>();

    public JsonRenderer(Log log, File targetFolder, String filename, boolean fullGitMessage) throws IOException {
        super(log, targetFolder, filename, false);
        this.fullGitMessage = fullGitMessage;
        this.template = this.loadResourceToString("/json/JsonItemTemplate.html");
    }

    @Override
    public void renderHeader(String reportTitle) throws IOException {
        this.json.append("[\n");
    }

    @Override
    public void renderTag(RevTag tag) throws IOException {
        this.tags.add(tag);
    }

    @Override
    public void renderCommit(RevCommit commit) throws IOException {
        String date = Formatter.formatDateTime(commit.getCommitTime());
        String message = null;
        message = this.fullGitMessage ? commit.getFullMessage() : commit.getShortMessage();
        StringBuffer tagsJson = new StringBuffer();
        boolean firstTag = true;
        for (RevTag tag : this.tags) {
            if (firstTag) {
                firstTag = false;
                tagsJson.append(" ");
            } else {
                tagsJson.append(", ");
            }
            tagsJson.append("{ \"name\":\"").append(JsonRenderer.encode(tag.getTagName())).append("\" }");
        }
        if (!firstTag) {
            tagsJson.append(" ");
        }
        this.tags.clear();
        if (this.firstCommit) {
            this.json.append("    ");
            this.firstCommit = false;
        } else {
            this.json.append("  , ");
        }
        String jsonItem = this.template.replace("{id}", JsonRenderer.encode(commit.getName())).replace("{message}", JsonRenderer.encode(message)).replace("{tagItems}", tagsJson.toString()).replace("{date}", JsonRenderer.encode(date));
        jsonItem = Formatter.showCommiter() ? jsonItem.replace("{authorName}", JsonRenderer.encode(commit.getAuthorIdent().getName())).replace("{authorEmail}", JsonRenderer.encode(commit.getAuthorIdent().getEmailAddress())).replace("{committerName}", JsonRenderer.encode(commit.getCommitterIdent().getName())).replace("{committerEmail}", JsonRenderer.encode(commit.getCommitterIdent().getEmailAddress())) : jsonItem.replace("{authorName}", "").replace("{authorEmail}", "").replace("{committerName}", "").replace("{committerEmail}", "");
        this.json.append(jsonItem);
        this.json.append("\n");
    }

    @Override
    public void renderFooter() throws IOException {
        this.json.append("]\n");
        this.writer.append(this.json);
    }

    protected static String encode(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        if (input.lastIndexOf("\n") == input.length() - 1) {
            input = input.substring(0, input.length() - 1);
        }
        input = input.replace("\\", "\\\\");
        input = input.replace("\n", "\\n");
        input = input.replace("\t", "\\t");
        input = input.replace("\b", "\\b");
        input = input.replace("\f", "\\f");
        input = input.replace("\r", "\\r");
        input = input.replace("\"", "\\\"");
        return input;
    }
}

