/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateImageResponse;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import java.io.InputStream;
import java.util.Objects;

public class CreateImageCmdImpl
extends AbstrDockerCmd<CreateImageCmd, CreateImageResponse>
implements CreateImageCmd {
    private String repository;
    private String tag;
    private String platform;
    private InputStream imageStream;

    public CreateImageCmdImpl(CreateImageCmd.Exec exec, String repository, InputStream imageStream) {
        super(exec);
        this.withRepository(repository);
        this.withImageStream(imageStream);
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public String getPlatform() {
        return this.platform;
    }

    public InputStream getImageStream() {
        return this.imageStream;
    }

    public CreateImageCmdImpl withRepository(String repository) {
        Objects.requireNonNull(repository, "repository was not specified");
        this.repository = repository;
        return this;
    }

    public CreateImageCmdImpl withImageStream(InputStream imageStream) {
        Objects.requireNonNull(imageStream, "imageStream was not specified");
        this.imageStream = imageStream;
        return this;
    }

    public CreateImageCmdImpl withTag(String tag) {
        Objects.requireNonNull(tag, "tag was not specified");
        this.tag = tag;
        return this;
    }

    public CreateImageCmd withPlatform(String platform) {
        this.platform = platform;
        return this;
    }
}

