/*
 * Decompiled with CFR 0.152.
 */
package com.github.dzieciou.testing.curl;

import com.github.dzieciou.testing.curl.CurlLoggingInterceptor;
import com.github.dzieciou.testing.curl.Options;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.RestAssuredConfig;
import java.lang.reflect.Field;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.AbstractHttpClient;

public class CurlLoggingRestAssuredConfigFactory {
    public static RestAssuredConfig createConfig() {
        return CurlLoggingRestAssuredConfigFactory.createConfig(CurlLoggingRestAssuredConfigFactory.getDefaultOptions());
    }

    public static RestAssuredConfig createConfig(Options options) {
        return CurlLoggingRestAssuredConfigFactory.updateConfig(RestAssuredConfig.config(), options);
    }

    public static RestAssuredConfig updateConfig(RestAssuredConfig config) {
        return CurlLoggingRestAssuredConfigFactory.updateConfig(config, CurlLoggingRestAssuredConfigFactory.getDefaultOptions());
    }

    public static RestAssuredConfig updateConfig(RestAssuredConfig config, Options options) {
        HttpClientConfig.HttpClientFactory originalFactory = CurlLoggingRestAssuredConfigFactory.getHttpClientFactory(config);
        return config.httpClient(config.getHttpClientConfig().reuseHttpClientInstance().httpClientFactory((HttpClientConfig.HttpClientFactory)new MyHttpClientFactory(originalFactory, new CurlLoggingInterceptor(options))));
    }

    private static Options getDefaultOptions() {
        return Options.builder().dontLogStacktrace().printSingleliner().useShortForm().escapeNonAscii().build();
    }

    private static HttpClientConfig.HttpClientFactory getHttpClientFactory(RestAssuredConfig config) {
        try {
            Field f = HttpClientConfig.class.getDeclaredField("httpClientFactory");
            f.setAccessible(true);
            HttpClientConfig httpClientConfig = config.getHttpClientConfig();
            HttpClientConfig.HttpClientFactory httpClientFactory = (HttpClientConfig.HttpClientFactory)f.get(httpClientConfig);
            f.setAccessible(false);
            return httpClientFactory;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MyHttpClientFactory
    implements HttpClientConfig.HttpClientFactory {
        private final HttpClientConfig.HttpClientFactory wrappedFactory;
        private final CurlLoggingInterceptor curlLoggingInterceptor;

        public MyHttpClientFactory(HttpClientConfig.HttpClientFactory wrappedFactory, CurlLoggingInterceptor curlLoggingInterceptor) {
            this.wrappedFactory = wrappedFactory;
            this.curlLoggingInterceptor = curlLoggingInterceptor;
        }

        public HttpClient createHttpClient() {
            AbstractHttpClient client = (AbstractHttpClient)this.wrappedFactory.createHttpClient();
            client.addRequestInterceptor((HttpRequestInterceptor)this.curlLoggingInterceptor);
            return client;
        }
    }
}

