/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.IncrementalBuildExecutionDigest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.codec.digest.MurmurHash3;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalMojoHelper {
    private static final String MVN_LIST_SEPARATOR = ",";
    public static final String DEFAULT_EXCLUDED_FILENAMES = ".node,node_modules,lcov-report,coverage,screenshots,build,dist,target,.idea,.history,tmp,.settings,.vscode,.git,dependency-reduced-pom.xml,.flattened-pom.xml";
    private static final Logger log = LoggerFactory.getLogger(IncrementalMojoHelper.class);
    private static final String SEE_DEBUG_LOGS_MSG = " See the Maven debug logs (run with -X) for more info";
    private static ObjectMapper objectMapper;
    private final IncrementalBuildExecutionDigest.ExecutionCoordinates coordinates;
    private final File targetDirectory;
    private final File workingDirectory;
    private final boolean isActive;
    private final Set<File> triggerFiles;
    private final Set<String> excludedFilenames;
    private IncrementalBuildExecutionDigest digest;
    private Optional<Instant> startTimeForSavedTimeUpdate = Optional.empty();

    public IncrementalMojoHelper(String activationFlag, IncrementalBuildExecutionDigest.ExecutionCoordinates coordinates, File targetDirectory, File workingDirectory, Set<File> triggerFiles, Set<String> excludedFilenames) {
        this.coordinates = Objects.requireNonNull(coordinates, "coordinates");
        this.targetDirectory = Objects.requireNonNull(targetDirectory, "targetDirectory");
        this.workingDirectory = Objects.requireNonNull(workingDirectory, "workingDirectory");
        this.triggerFiles = Objects.isNull(triggerFiles) ? Collections.emptySet() : triggerFiles;
        this.excludedFilenames = Objects.isNull(excludedFilenames) ? Collections.emptySet() : excludedFilenames;
        this.isActive = "true".equals(activationFlag);
    }

    public boolean incrementalEnabled() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeSkipped(String arguments, Optional<IncrementalBuildExecutionDigest.Execution.Runtime> runtime, Map<String, String> suppliedEnvVars, String artifactId, String forkVersion) {
        AtlassianDevMetricsReporter.Timer timer = new AtlassianDevMetricsReporter.Timer();
        boolean failed = false;
        if (!this.isActive) {
            return false;
        }
        if (!runtime.isPresent()) {
            log.warn("Failed to do incremental compilation because the runtime version couldn't be fetched. See the Maven debug logs (run with -X) for more info");
            return false;
        }
        try {
            try {
                File digestFileLocation = this.getDigestFile();
                if (digestFileLocation.exists()) {
                    this.digest = this.readDigest(digestFileLocation);
                }
            }
            catch (FileNotFoundException exception) {
                log.debug("No existing digest file", (Throwable)exception);
            }
            if (Objects.isNull(this.digest)) {
                this.digest = new IncrementalBuildExecutionDigest(IncrementalBuildExecutionDigest.CURRENT_DIGEST_VERSION, new HashMap<IncrementalBuildExecutionDigest.ExecutionCoordinates, IncrementalBuildExecutionDigest.Execution>());
            }
            boolean digestVersionsMatch = Objects.equals(this.digest.digestVersion, IncrementalBuildExecutionDigest.CURRENT_DIGEST_VERSION);
            IncrementalBuildExecutionDigest.Execution thisExecution = new IncrementalBuildExecutionDigest.Execution(arguments, IncrementalMojoHelper.getAllEnvVars(suppliedEnvVars), this.createFilesDigest(), runtime.get());
            this.startTimeForSavedTimeUpdate = Optional.of(Instant.now());
            boolean canSkipExecution = false;
            IncrementalBuildExecutionDigest.Execution previousExecution = this.digest.executions.get(this.coordinates);
            if (digestVersionsMatch && previousExecution != null) {
                thisExecution.millisecondsSaved = previousExecution.millisecondsSaved;
                canSkipExecution = previousExecution.equals(thisExecution);
                if (canSkipExecution) {
                    this.startTimeForSavedTimeUpdate = Optional.empty();
                    log.info("Saving {} by skipping execution of frontend-maven-plugin! No changes were detected. If it should have executed, adjust the triggerFiles and excludedFilenames in the configuration.", (Object)Duration.ofMillis(previousExecution.millisecondsSaved));
                } else {
                    log.info("Didn't do incremental compilation because a change was detected for executionId:  {} in artifactId: {} See the Maven debug logs (run with -X) for more info", (Object)this.coordinates.id, (Object)artifactId);
                    if (log.isDebugEnabled()) {
                        String argumentsDifference = StringUtils.difference((String)previousExecution.arguments, (String)thisExecution.arguments);
                        String envVarDifference = StringUtils.difference((String)previousExecution.environmentVariables.toString(), (String)thisExecution.environmentVariables.toString());
                        String runtimeDifference = StringUtils.difference((String)previousExecution.runtime.toString(), (String)thisExecution.runtime.toString());
                        HashSet<IncrementalBuildExecutionDigest.Execution.File> newFiles = new HashSet<IncrementalBuildExecutionDigest.Execution.File>(thisExecution.files);
                        newFiles.removeAll(previousExecution.files);
                        HashSet<IncrementalBuildExecutionDigest.Execution.File> goneFiles = new HashSet<IncrementalBuildExecutionDigest.Execution.File>(previousExecution.files);
                        goneFiles.removeAll(thisExecution.files);
                        if (!argumentsDifference.trim().isEmpty()) {
                            log.debug("Difference in arguments was: <{}> previously: <{}>, currently <{}>", new Object[]{argumentsDifference, previousExecution.arguments, thisExecution.arguments});
                        }
                        if (!envVarDifference.trim().isEmpty()) {
                            log.debug("Difference in environment variables was: <{}> previously: <{}>, currently <{}>", new Object[]{envVarDifference, previousExecution.environmentVariables, thisExecution.environmentVariables});
                        }
                        if (!runtimeDifference.trim().isEmpty()) {
                            log.debug("Difference in runtime was: <{}> previously: <{}>, currently <{}>", new Object[]{runtimeDifference, previousExecution.runtime, thisExecution.runtime});
                        }
                        if (!newFiles.isEmpty()) {
                            log.debug("Some files are \"new\" (may have changed meta-data), there were: {}", newFiles);
                        }
                        if (!goneFiles.isEmpty()) {
                            log.debug("Some files are \"gone\" (may have changed meta-data), there were: {}", goneFiles);
                        }
                    }
                }
            }
            this.digest.digestVersion = IncrementalBuildExecutionDigest.CURRENT_DIGEST_VERSION;
            this.digest.executions.put(this.coordinates, thisExecution);
            boolean bl = canSkipExecution;
            timer.stop("execute.incremental.check", artifactId, forkVersion, "", (Map<String, String>)new HashMap<String, String>(failed){
                final /* synthetic */ boolean val$failed;
                {
                    this.val$failed = bl;
                    this.put("failed", Boolean.toString(this.val$failed));
                }
            });
            return bl;
        }
        catch (Exception exception) {
            try {
                log.error("Failure while determining if an incremental build is possible. See the Maven debug logs (run with -X) for more info");
                log.debug("Failure while determining if an incremental build is possible, because: ", (Throwable)exception);
                boolean bl = false;
                timer.stop("execute.incremental.check", artifactId, forkVersion, "", (Map<String, String>)new /* invalid duplicate definition of identical inner class */);
                return bl;
            }
            catch (Throwable throwable) {
                timer.stop("execute.incremental.check", artifactId, forkVersion, "", (Map<String, String>)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    public void acceptIncrementalBuildDigest() {
        if (!this.isActive) {
            return;
        }
        this.startTimeForSavedTimeUpdate.ifPresent(instant -> {
            this.digest.executions.get((Object)this.coordinates).millisecondsSaved = Duration.between(instant, Instant.now()).toMillis();
        });
        try {
            log.debug("Accepting the incremental build digest after a successful execution");
            File digestFile = this.getDigestFile();
            if (digestFile.exists() && !digestFile.delete()) {
                log.warn("Failed to delete the previous incremental build digest. You'll have to delete it manually @ {}", (Object)digestFile.getAbsolutePath());
            }
            digestFile.getParentFile().mkdirs();
            this.saveDigest(this.digest);
        }
        catch (Exception exception) {
            log.warn("Failed to save the incremental build digest. See the Maven debug logs (run with -X) for more info");
            log.debug("Failed to save the incremental build digest, because: ", (Throwable)exception);
        }
    }

    private Set<IncrementalBuildExecutionDigest.Execution.File> createFilesDigest() throws IOException {
        HashSet<IncrementalBuildExecutionDigest.Execution.File> files = new HashSet<IncrementalBuildExecutionDigest.Execution.File>();
        IncrementalVisitor visitor = new IncrementalVisitor(files, this.excludedFilenames);
        Files.walkFileTree(this.workingDirectory.toPath(), visitor);
        this.triggerFiles.forEach(file -> IncrementalMojoHelper.addTrackedFile(files, file.toPath()));
        return files;
    }

    private static void addTrackedFile(Collection<IncrementalBuildExecutionDigest.Execution.File> files, Path file) {
        try {
            byte[] fileBytes = Files.readAllBytes(file);
            long[] hash = MurmurHash3.hash128x64((byte[])fileBytes);
            String hashString = Arrays.toString(hash);
            files.add(new IncrementalBuildExecutionDigest.Execution.File(file.toString(), fileBytes.length, hashString));
        }
        catch (IOException exception) {
            throw new RuntimeException(String.format("Failed to read file: %s", file), exception);
        }
        catch (Error e) {
            try {
                log.error("addTrackedFile: files.size(): {}, file: '{}', Files.size(file): {}", new Object[]{files.size(), file, Files.size(file), e});
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw e;
        }
    }

    private static Map<String, String> getAllEnvVars(Map<String, String> userDefinedEnvVars) {
        HashMap<String, String> effectiveEnvVars = new HashMap<String, String>();
        List<String> defaultEnvVars = Arrays.asList("NODE_ENV", "BABEL_ENV", "OS", "OS_VERSION", "OS_ARCH", "OS_NAME", "OS_FAMILY");
        defaultEnvVars.forEach(envVarKey -> {
            String envVarValue = System.getenv(envVarKey);
            effectiveEnvVars.put((String)envVarKey, IncrementalMojoHelper.nullStringIsEmpty(envVarValue));
        });
        if (userDefinedEnvVars != null) {
            effectiveEnvVars.putAll(userDefinedEnvVars);
        }
        return effectiveEnvVars;
    }

    private static String nullStringIsEmpty(String string) {
        if (Objects.isNull(string)) {
            return "";
        }
        return string;
    }

    static ObjectMapper getObjectMapper() {
        if (Objects.isNull(objectMapper)) {
            objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, false);
        }
        return objectMapper;
    }

    private void saveDigest(IncrementalBuildExecutionDigest digest) throws IOException {
        IncrementalMojoHelper.getObjectMapper().writeValue(this.getDigestFile(), (Object)digest);
    }

    private IncrementalBuildExecutionDigest readDigest(File digest) throws IOException {
        return (IncrementalBuildExecutionDigest)IncrementalMojoHelper.getObjectMapper().readValue(digest, IncrementalBuildExecutionDigest.class);
    }

    private File getDigestFile() {
        return new File(this.targetDirectory, "frontend-maven-plugin-incremental-build-digest.json");
    }

    static class IncrementalVisitor
    extends SimpleFileVisitor<Path> {
        private final Set<IncrementalBuildExecutionDigest.Execution.File> files;
        private final Set<String> excludedFilenames;
        private static final Set<String> DIGEST_EXTENSIONS = new HashSet<String>(Arrays.asList("js", "jsx", "cjs", "mjs", "ts", "tsx", "patch", "css", "scss", "sass", "less", "styl", "stylus", "ejs", "hbs", "handlebars", "pug", "soy", "html", "vm", "vmd", "vtl", "ftl", "graphql", "json", "xml", "yaml", "yml", "csv", "lock", "apng", "png", "jpg", "jpeg", "gif", "webp", "svg", "ico", "bmp", "tiff", "tif", "avif", "eps", "ttf", "otf", "woff", "woff2", "eot", "sfnt", "mp3", "mp4", "webm", "wav", "flac", "aac", "ogg", "oga", "opus", "m4a", "m4v", "mov", "avi", "wmv", "flv", "mkv", "flac"));
        private static final Set<String> DIGEST_FILES = new HashSet<String>(Arrays.asList(".parcelrc", ".babelrc", ".eslintrc", ".eslintignore", ".prettierrc", ".prettierrc.js", ".prettierignore", ".stylelintrc", ".stylelintignore", ".browserslistrc", ".npmrc", ".swcrc"));

        public IncrementalVisitor(Set<IncrementalBuildExecutionDigest.Execution.File> files, Set<String> excludedFilenames) {
            this.files = files;
            this.excludedFilenames = excludedFilenames;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) {
            String filename = file.getFileName().toString();
            if (this.excludedFilenames.contains(filename)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            String fileName = file.getFileName().toString();
            if (this.excludedFilenames.contains(fileName)) {
                return FileVisitResult.CONTINUE;
            }
            if (DIGEST_FILES.contains(fileName) || DIGEST_EXTENSIONS.contains(IncrementalVisitor.getFileExtension(fileName))) {
                IncrementalMojoHelper.addTrackedFile(this.files, file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException exception) throws IOException {
            log.debug("Failed to visit {}", (Object)path, (Object)exception);
            return super.visitFileFailed(path, exception);
        }

        private static String getFileExtension(String fileName) {
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex > 0 && dotIndex < fileName.length() - 1) {
                return fileName.substring(dotIndex + 1);
            }
            return null;
        }
    }
}

