/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.IJsonObject;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.Knot;
import com.github.erosb.jsonsKema.SchemaLoaderKt;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0006J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c2\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c2\u0003J?\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0006J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\b\u0010$\u001a\u0004\u0018\u00010\u0007J\b\u0010%\u001a\u0004\u0018\u00010\u0007J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0016\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0003J\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00062\u000e\u0010)\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-J\t\u0010.\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/github/erosb/jsonsKema/LoadingState;", "", "documentRoot", "Lcom/github/erosb/jsonsKema/IJsonValue;", "anchors", "", "", "Lcom/github/erosb/jsonsKema/Knot;", "dynamicAnchors", "(Lcom/github/erosb/jsonsKema/IJsonValue;Ljava/util/Map;Ljava/util/Map;)V", "_baseURI", "Ljava/net/URI;", "get_baseURI", "()Ljava/net/URI;", "set_baseURI", "(Ljava/net/URI;)V", "value", "baseURI", "getBaseURI", "setBaseURI", "getDocumentRoot", "()Lcom/github/erosb/jsonsKema/IJsonValue;", "anchorByURI", "ref", "component1", "component2", "component3", "copy", "equals", "", "other", "getAnchorByURI", "uri", "getDynAnchorByURI", "hashCode", "", "nextLoadableAnchor", "nextUnresolvedAnchor", "normalizeUri", "registerRawSchemaByAnchor", "id", "json", "registerRawSchemaByDynAnchor", "", "dynAnchor", "Lcom/github/erosb/jsonsKema/IJsonObject;", "toString", "json-sKema"})
public final class LoadingState {
    @NotNull
    private final IJsonValue documentRoot;
    @NotNull
    private final Map<String, Knot> anchors;
    @NotNull
    private final Map<String, Knot> dynamicAnchors;
    @NotNull
    private URI _baseURI;

    public LoadingState(@NotNull IJsonValue documentRoot, @NotNull Map<String, Knot> anchors, @NotNull Map<String, Knot> dynamicAnchors) {
        Intrinsics.checkNotNullParameter((Object)documentRoot, (String)"documentRoot");
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        Intrinsics.checkNotNullParameter(dynamicAnchors, (String)"dynamicAnchors");
        this.documentRoot = documentRoot;
        this.anchors = anchors;
        this.dynamicAnchors = dynamicAnchors;
        this._baseURI = new URI(SchemaLoaderKt.getDEFAULT_BASE_URI());
    }

    public /* synthetic */ LoadingState(IJsonValue iJsonValue, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 4) != 0) {
            map2 = new LinkedHashMap();
        }
        this(iJsonValue, map, map2);
    }

    @NotNull
    public final IJsonValue getDocumentRoot() {
        return this.documentRoot;
    }

    @NotNull
    public final URI get_baseURI() {
        return this._baseURI;
    }

    public final void set_baseURI(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<set-?>");
        this._baseURI = uRI;
    }

    @NotNull
    public final URI getBaseURI() {
        return this._baseURI;
    }

    public final void setBaseURI(@NotNull URI value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._baseURI = value;
    }

    @NotNull
    public final Knot registerRawSchemaByAnchor(@NotNull String id, @NotNull IJsonValue json) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Knot anchor = this.getAnchorByURI(id);
        if (anchor.getJson() != null && anchor.getJson() != json) {
            throw new IllegalStateException("raw schema already registered by URI " + id);
        }
        anchor.setJson(json);
        return anchor;
    }

    @Nullable
    public final Knot nextLoadableAnchor() {
        Object v0;
        block1: {
            Iterable iterable = this.anchors.values();
            for (Object t : iterable) {
                Knot it = (Knot)t;
                boolean bl = false;
                if (!it.isLoadable()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Knot nextUnresolvedAnchor() {
        Object v0;
        block1: {
            Iterable iterable = this.anchors.values();
            for (Object t : iterable) {
                Knot it = (Knot)t;
                boolean bl = false;
                if (!(it.getJson() == null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Knot getAnchorByURI(@NotNull String uri) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Map<String, Knot> map = this.anchors;
        String key$iv = this.normalizeUri(uri);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Knot answer$iv = new Knot(null, null, null, false, null, 31, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Knot)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Knot getDynAnchorByURI(@NotNull String uri) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Map<String, Knot> map = this.dynamicAnchors;
        String key$iv = this.normalizeUri(uri);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Knot answer$iv = new Knot(null, null, null, false, null, 31, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Knot)object;
    }

    @Nullable
    public final Knot anchorByURI(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this.anchors.get(this.normalizeUri(ref));
    }

    private final String normalizeUri(String uri) {
        String string;
        String effectiveUri = null;
        if (StringsKt.startsWith$default((String)uri, (String)"file:/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)uri, (String)"file:///", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append("file:///");
            String string2 = uri.substring("file:/".length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            effectiveUri = stringBuilder.append(string2).toString();
        } else {
            effectiveUri = uri;
        }
        if (StringsKt.endsWith$default((String)effectiveUri, (String)"#", (boolean)false, (int)2, null)) {
            String string3 = effectiveUri.substring(0, effectiveUri.length() - 1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = effectiveUri;
        }
        return string;
    }

    public final void registerRawSchemaByDynAnchor(@NotNull String dynAnchor, @NotNull IJsonObject<?, ?> json) {
        Intrinsics.checkNotNullParameter((Object)dynAnchor, (String)"dynAnchor");
        Intrinsics.checkNotNullParameter(json, (String)"json");
        this.getDynAnchorByURI(dynAnchor).setJson(json);
    }

    @NotNull
    public final IJsonValue component1() {
        return this.documentRoot;
    }

    private final Map<String, Knot> component2() {
        return this.anchors;
    }

    private final Map<String, Knot> component3() {
        return this.dynamicAnchors;
    }

    @NotNull
    public final LoadingState copy(@NotNull IJsonValue documentRoot, @NotNull Map<String, Knot> anchors, @NotNull Map<String, Knot> dynamicAnchors) {
        Intrinsics.checkNotNullParameter((Object)documentRoot, (String)"documentRoot");
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        Intrinsics.checkNotNullParameter(dynamicAnchors, (String)"dynamicAnchors");
        return new LoadingState(documentRoot, anchors, dynamicAnchors);
    }

    public static /* synthetic */ LoadingState copy$default(LoadingState loadingState, IJsonValue iJsonValue, Map map, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            iJsonValue = loadingState.documentRoot;
        }
        if ((n & 2) != 0) {
            map = loadingState.anchors;
        }
        if ((n & 4) != 0) {
            map2 = loadingState.dynamicAnchors;
        }
        return loadingState.copy(iJsonValue, map, map2);
    }

    @NotNull
    public String toString() {
        return "LoadingState(documentRoot=" + this.documentRoot + ", anchors=" + this.anchors + ", dynamicAnchors=" + this.dynamicAnchors + ')';
    }

    public int hashCode() {
        int result = this.documentRoot.hashCode();
        result = result * 31 + ((Object)this.anchors).hashCode();
        result = result * 31 + ((Object)this.dynamicAnchors).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LoadingState)) {
            return false;
        }
        LoadingState loadingState = (LoadingState)other;
        if (!Intrinsics.areEqual((Object)this.documentRoot, (Object)loadingState.documentRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.anchors, loadingState.anchors)) {
            return false;
        }
        return Intrinsics.areEqual(this.dynamicAnchors, loadingState.dynamicAnchors);
    }
}

