/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallContextCache;
import com.kenai.jffi.Closure;
import com.kenai.jffi.ClosureManager;
import com.kenai.jffi.ClosurePool;
import com.kenai.jffi.Type;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.annotations.Delegate;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.jffi.AsmClassLoader;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.ClosureUtil;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.NativeClosure;
import jnr.ffi.provider.jffi.NativeClosurePointer;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeClosureFactory<T>
implements ToNativeConverter<Object, Pointer> {
    public static final boolean DEBUG = Boolean.getBoolean("jnr.ffi.compile.dump");
    private static final AtomicLong nextClassID = new AtomicLong(0L);
    private final NativeRuntime runtime;
    private final CallContext callContext;
    private final Constructor<? extends NativeClosure> nativeClosureConstructor;
    private final ConcurrentMap<Integer, NativeClosurePointer> closures = new ConcurrentHashMap<Integer, NativeClosurePointer>();
    private final ClosurePool closurePool;
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();

    protected NativeClosureFactory(NativeRuntime runtime, CallContext callContext, Constructor<? extends NativeClosure> nativeClosureConstructor) {
        this.runtime = runtime;
        this.callContext = callContext;
        this.nativeClosureConstructor = nativeClosureConstructor;
        this.closurePool = ClosureManager.getInstance().getClosurePool(callContext);
    }

    static <T> NativeClosureFactory newClosureFactory(NativeRuntime runtime, Class<T> closureClass) {
        long classIdx = nextClassID.getAndIncrement();
        String closureInstanceClassName = CodegenUtils.p(NativeClosureFactory.class) + "$ClosureInstance";
        ClassWriter closureClassWriter = new ClassWriter(2);
        ClassWriter closureClassVisitor = DEBUG ? AsmUtil.newCheckClassAdapter((ClassVisitor)closureClassWriter) : closureClassWriter;
        closureClassVisitor.visit(49, 17, closureInstanceClassName, null, CodegenUtils.p(NativeClosure.class), new String[]{CodegenUtils.p(Closure.class)});
        SkinnyMethodAdapter closureInit = new SkinnyMethodAdapter(closureClassVisitor.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, NativeRuntime.class, Object.class, ReferenceQueue.class, Integer.class), null, null));
        closureInit.start();
        closureInit.aload(0);
        closureInit.aload(1);
        closureInit.aload(2);
        closureInit.aload(3);
        closureInit.aload(4);
        closureInit.invokespecial(CodegenUtils.p(NativeClosure.class), "<init>", CodegenUtils.sig(Void.TYPE, NativeRuntime.class, Object.class, ReferenceQueue.class, Integer.class));
        closureInit.voidreturn();
        closureInit.visitMaxs(10, 10);
        closureInit.visitEnd();
        Method callMethod = null;
        for (Method m : closureClass.getMethods()) {
            if (!m.isAnnotationPresent(Delegate.class) || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) continue;
            callMethod = m;
            break;
        }
        if (callMethod == null) {
            throw new NoSuchMethodError("no public non-static delegate method defined in " + closureClass.getName());
        }
        SkinnyMethodAdapter closureInvoke = new SkinnyMethodAdapter(closureClassVisitor.visitMethod(1, "invoke", CodegenUtils.sig(Void.TYPE, Closure.Buffer.class, Object.class), null, null));
        closureInvoke.start();
        if (Void.TYPE != callMethod.getReturnType() && Void.class != callMethod.getReturnType()) {
            closureInvoke.aload(1);
        }
        closureInvoke.aload(2);
        closureInvoke.checkcast(CodegenUtils.p(closureClass));
        Class<?>[] parameterTypes = callMethod.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class type;
            Class parameterType = parameterTypes[i];
            if (!NativeClosureFactory.isParameterTypeSupported(parameterType)) {
                throw new IllegalArgumentException("unsupported closure parameter type " + parameterType);
            }
            closureInvoke.aload(1);
            closureInvoke.pushInt(i);
            Class clazz = type = parameterType.isPrimitive() ? parameterType : AsmUtil.unboxedType(parameterType);
            if (Byte.TYPE == type) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getByte", CodegenUtils.sig(type, Integer.TYPE));
            } else if (Character.TYPE == type) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getShort", CodegenUtils.sig(Short.TYPE, Integer.TYPE));
            } else if (Short.TYPE == type) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getShort", CodegenUtils.sig(type, Integer.TYPE));
            } else if (Integer.TYPE == type) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getInt", CodegenUtils.sig(type, Integer.TYPE));
            } else if (Long.TYPE == type && (Long.TYPE == parameterType || Long.class == parameterType)) {
                if (NumberUtil.isLong32(parameterType, callMethod.getParameterAnnotations()[i])) {
                    closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getInt", CodegenUtils.sig(Integer.TYPE, Integer.TYPE));
                    NumberUtil.widen(closureInvoke, Integer.TYPE, Long.TYPE);
                } else {
                    closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getLong", CodegenUtils.sig(Long.TYPE, Integer.TYPE));
                }
            } else if (Long.TYPE == type) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getLong", CodegenUtils.sig(Long.TYPE, Integer.TYPE));
            } else if (Float.TYPE == type) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getFloat", CodegenUtils.sig(type, Integer.TYPE));
            } else if (Double.TYPE == type) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "getDouble", CodegenUtils.sig(type, Integer.TYPE));
            } else {
                throw new IllegalArgumentException("unsupported closure parameter type " + parameterType);
            }
            AsmUtil.boxValue(closureInvoke, parameterType, type);
        }
        if (callMethod.getDeclaringClass().isInterface()) {
            closureInvoke.invokeinterface(CodegenUtils.p(closureClass), callMethod.getName(), CodegenUtils.sig(callMethod.getReturnType(), callMethod.getParameterTypes()));
        } else {
            closureInvoke.invokevirtual(CodegenUtils.p(closureClass), callMethod.getName(), CodegenUtils.sig(callMethod.getReturnType(), callMethod.getParameterTypes()));
        }
        Class<?> returnType = callMethod.getReturnType();
        if (!NativeClosureFactory.isReturnTypeSupported(returnType)) {
            throw new IllegalArgumentException("unsupported closure return type " + returnType.getName());
        }
        Annotation[] returnAnnotations = callMethod.getAnnotations();
        Class<Integer> nativeReturnType = AsmUtil.unboxedType(returnType);
        if (NumberUtil.isLong32(returnType, returnAnnotations)) {
            nativeReturnType = Integer.TYPE;
        }
        if (Number.class.isAssignableFrom(returnType)) {
            AsmUtil.unboxNumber(closureInvoke, returnType, nativeReturnType);
        } else if (Boolean.class.isAssignableFrom(returnType)) {
            AsmUtil.unboxBoolean(closureInvoke, nativeReturnType);
        } else if (Pointer.class.isAssignableFrom(returnType)) {
            AsmUtil.unboxPointer(closureInvoke, nativeReturnType);
        } else if (Enum.class.isAssignableFrom(returnType)) {
            AsmUtil.unboxEnum(closureInvoke, nativeReturnType);
        }
        if (Void.TYPE != nativeReturnType && Void.class != nativeReturnType) {
            if (Byte.TYPE == nativeReturnType) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "setByteReturn", CodegenUtils.sig(Void.TYPE, Byte.TYPE));
            } else if (Short.TYPE == nativeReturnType || Character.TYPE == nativeReturnType) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "setShortReturn", CodegenUtils.sig(Void.TYPE, Short.TYPE));
            } else if (Integer.TYPE == nativeReturnType) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "setIntReturn", CodegenUtils.sig(Void.TYPE, Integer.TYPE));
            } else if (Long.TYPE == nativeReturnType) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "setLongReturn", CodegenUtils.sig(Void.TYPE, Long.TYPE));
            } else if (Float.TYPE == nativeReturnType) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "setFloatReturn", CodegenUtils.sig(Void.TYPE, Float.TYPE));
            } else if (Double.TYPE == nativeReturnType) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "setDoubleReturn", CodegenUtils.sig(Void.TYPE, Double.TYPE));
            } else if (Boolean.TYPE == nativeReturnType) {
                closureInvoke.invokeinterface(CodegenUtils.p(Closure.Buffer.class), "setIntReturn", CodegenUtils.sig(Void.TYPE, Integer.TYPE));
            }
        }
        closureInvoke.voidreturn();
        closureInvoke.visitMaxs(10, 10);
        closureInvoke.visitEnd();
        closureClassVisitor.visitEnd();
        try {
            ClassLoader cl;
            byte[] closureImpBytes = closureClassWriter.toByteArray();
            if (DEBUG) {
                ClassVisitor trace = AsmUtil.newTraceClassVisitor(new PrintWriter(System.err));
                new ClassReader(closureImpBytes).accept(trace, 0);
                trace.visitEnd();
            }
            if ((cl = NativeClosureFactory.class.getClassLoader()) == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            AsmClassLoader asm = new AsmClassLoader(cl);
            Class nativeClosureClass = asm.defineClass(CodegenUtils.c(closureInstanceClassName), closureImpBytes);
            Constructor nativeClosureConstructor = nativeClosureClass.getConstructor(NativeRuntime.class, Object.class, ReferenceQueue.class, Integer.class);
            return new NativeClosureFactory<T>(runtime, NativeClosureFactory.getCallContext(callMethod), nativeClosureConstructor);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isReturnTypeSupported(Class type) {
        return type.isPrimitive() || Boolean.TYPE == type || Boolean.class == type || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type || NativeLong.class == type || Enum.class.isAssignableFrom(type) || Pointer.class == type;
    }

    private static boolean isParameterTypeSupported(Class type) {
        return type.isPrimitive() || Boolean.TYPE == type || Boolean.class == type || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type || NativeLong.class == type || Pointer.class == type || String.class == type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expunge(Reference<? extends Object> ref) {
        NativeClosure cl = (NativeClosure)NativeClosure.class.cast(ref);
        Integer key = cl.getKey();
        NativeClosurePointer ptr = (NativeClosurePointer)this.closures.get(key);
        if (ptr == null) {
            return;
        }
        if (ptr.next == null && this.closures.remove(key, ptr)) {
            return;
        }
        ConcurrentMap<Integer, NativeClosurePointer> concurrentMap = this.closures;
        synchronized (concurrentMap) {
            NativeClosurePointer prev = ptr;
            while (ptr != null) {
                if (ptr.getNativeClosure() == cl) {
                    if (prev != null) {
                        prev.next = ptr.next;
                        break;
                    }
                    if (ptr.next == null || !this.closures.replace(key, ptr, ptr.next)) {
                        // empty if block
                    }
                }
                ptr = ptr.next;
            }
        }
    }

    private void expunge() {
        Reference<Object> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            this.expunge(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Pointer toNative(Object callable, ToNativeContext context) {
        this.expunge();
        Integer key = System.identityHashCode(callable);
        NativeClosurePointer ptr = (NativeClosurePointer)this.closures.get(key);
        if (ptr != null) {
            if (ptr.getCallable() == callable) {
                return ptr;
            }
            ConcurrentMap<Integer, NativeClosurePointer> concurrentMap = this.closures;
            synchronized (concurrentMap) {
                while ((ptr = ptr.next) != null) {
                    if (ptr.getCallable() != callable) continue;
                    return ptr;
                }
            }
        }
        return this.newClosure(callable, key);
    }

    @Override
    public Class<Pointer> nativeType() {
        return Pointer.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NativeClosurePointer newClosure(Object callable, Integer key) {
        NativeClosure nativeClosure;
        try {
            nativeClosure = this.nativeClosureConstructor.newInstance(NativeRuntime.getInstance(), callable, this.referenceQueue, key);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        NativeClosurePointer ptr = new NativeClosurePointer(this.runtime, nativeClosure, this.closurePool.newClosureHandle((Closure)nativeClosure));
        this.expunge();
        if (this.closures.putIfAbsent(key, ptr) == null) {
            return ptr;
        }
        ConcurrentMap<Integer, NativeClosurePointer> concurrentMap = this.closures;
        synchronized (concurrentMap) {
            do {
                ptr.next = (NativeClosurePointer)this.closures.get(key);
            } while ((ptr.next != null || this.closures.putIfAbsent(key, ptr) != null) && this.closures.replace(key, ptr.next, ptr));
        }
        return ptr;
    }

    private static CallContext getCallContext(Method m) {
        Type resultType = ClosureUtil.getNativeResultType(m);
        Type[] parameterTypes = new Type[m.getParameterTypes().length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = ClosureUtil.getNativeParameterType(m, i);
        }
        return CallContextCache.getInstance().getCallContext(resultType, parameterTypes, ClosureUtil.getNativeCallingConvention(m));
    }
}

