/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Platform;
import java.lang.annotation.Annotation;
import jnr.ffi.NativeLong;
import jnr.ffi.annotations.LongLong;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;

public final class NumberUtil {
    private NumberUtil() {
    }

    static final Class getBoxedClass(Class c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (Void.TYPE == c) {
            return Void.class;
        }
        if (Byte.TYPE == c) {
            return Byte.class;
        }
        if (Character.TYPE == c) {
            return Character.class;
        }
        if (Short.TYPE == c) {
            return Short.class;
        }
        if (Integer.TYPE == c) {
            return Integer.class;
        }
        if (Long.TYPE == c) {
            return Long.class;
        }
        if (Float.TYPE == c) {
            return Float.class;
        }
        if (Double.TYPE == c) {
            return Double.class;
        }
        if (Boolean.TYPE == c) {
            return Boolean.class;
        }
        throw new IllegalArgumentException("unknown primitive class");
    }

    static final Class getPrimitiveClass(Class c) {
        if (Void.class == c) {
            return Void.TYPE;
        }
        if (Boolean.class == c) {
            return Boolean.TYPE;
        }
        if (Byte.class == c) {
            return Byte.TYPE;
        }
        if (Character.class == c) {
            return Character.TYPE;
        }
        if (Short.class == c) {
            return Short.TYPE;
        }
        if (Integer.class == c) {
            return Integer.TYPE;
        }
        if (Long.class == c) {
            return Long.TYPE;
        }
        if (Float.class == c) {
            return Float.TYPE;
        }
        if (Double.class == c) {
            return Double.TYPE;
        }
        if (NativeLong.class == c) {
            return Long.TYPE;
        }
        if (c.isPrimitive()) {
            return c;
        }
        throw new IllegalArgumentException("unsupported number class");
    }

    public static boolean isPrimitiveInt(Class c) {
        return Byte.TYPE == c || Character.TYPE == c || Short.TYPE == c || Integer.TYPE == c || Boolean.TYPE == c;
    }

    public static final void widen(SkinnyMethodAdapter mv, Class from, Class to) {
        if (Long.TYPE == to && Long.TYPE != from && NumberUtil.isPrimitiveInt(from)) {
            mv.i2l();
        }
    }

    public static final void narrow(SkinnyMethodAdapter mv, Class from, Class to) {
        if (!(from.equals(to) || Byte.TYPE != to && Short.TYPE != to && Character.TYPE != to && Integer.TYPE != to && Boolean.TYPE != to)) {
            if (Long.TYPE == from) {
                mv.l2i();
            }
            if (Byte.TYPE == to) {
                mv.i2b();
            } else if (Short.TYPE == to) {
                mv.i2s();
            } else if (Character.TYPE == to) {
                mv.i2c();
            } else if (Boolean.TYPE == to) {
                mv.iconst_1();
                mv.iand();
            }
        }
    }

    static boolean isLong32(Class type, Annotation[] annotations) {
        return NumberUtil.isLong32(Platform.getPlatform(), type, annotations);
    }

    static boolean isLong32(Platform platform, Class type, Annotation[] annotations) {
        return platform.longSize() == 32 && ((Long.TYPE == type || Long.class.isAssignableFrom(type)) && !InvokerUtil.hasAnnotation(annotations, LongLong.class) || NativeLong.class.isAssignableFrom(type));
    }

    static boolean isLong64(Class type, Annotation[] annotations) {
        int longSize = Platform.getPlatform().longSize();
        return (Long.TYPE == type || Long.class.isAssignableFrom(type)) && (longSize == 64 || InvokerUtil.hasAnnotation(annotations, LongLong.class)) || NativeLong.class.isAssignableFrom(type) && longSize == 64;
    }

    static boolean isInt32(Class type, Annotation[] annotations) {
        return Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type || Byte.class.isAssignableFrom(type) || Byte.TYPE == type || Short.class.isAssignableFrom(type) || Short.TYPE == type || Integer.class.isAssignableFrom(type) || Integer.TYPE == type || NumberUtil.isLong32(type, annotations) || Enum.class.isAssignableFrom(type);
    }
}

