/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.drools.configuration;

import java.io.IOException;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;
import org.kie.spring.KModuleBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
public class DroolsAutoConfiguration {
    private static final String RULES_PATH = "rules/";

    @Bean
    @ConditionalOnMissingBean(value={KieFileSystem.class})
    public KieFileSystem kieFileSystem() throws IOException {
        KieFileSystem kieFileSystem = this.getKieServices().newKieFileSystem();
        for (Resource file : this.getRuleFiles()) {
            kieFileSystem.write(ResourceFactory.newClassPathResource((String)(RULES_PATH + file.getFilename()), (String)"UTF-8"));
        }
        return kieFileSystem;
    }

    private Resource[] getRuleFiles() throws IOException {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        return resourcePatternResolver.getResources("classpath*:rules/**/*.*");
    }

    @Bean
    @ConditionalOnMissingBean(value={KieContainer.class})
    public KieContainer kieContainer() throws IOException {
        final KieRepository kieRepository = this.getKieServices().getRepository();
        kieRepository.addKieModule(new KieModule(){

            public ReleaseId getReleaseId() {
                return kieRepository.getDefaultReleaseId();
            }
        });
        KieBuilder kieBuilder = this.getKieServices().newKieBuilder(this.kieFileSystem());
        kieBuilder.buildAll();
        return this.getKieServices().newKieContainer(kieRepository.getDefaultReleaseId());
    }

    private KieServices getKieServices() {
        return KieServices.Factory.get();
    }

    @Bean
    @ConditionalOnMissingBean(value={KieBase.class})
    public KieBase kieBase() throws IOException {
        return this.kieContainer().getKieBase();
    }

    @Bean
    @ConditionalOnMissingBean(value={KieSession.class})
    public KieSession kieSession() throws IOException {
        return this.kieContainer().newKieSession();
    }

    @Bean
    @ConditionalOnMissingBean(value={KModuleBeanFactoryPostProcessor.class})
    public KModuleBeanFactoryPostProcessor kiePostProcessor() {
        return new KModuleBeanFactoryPostProcessor();
    }
}

