/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrubygradle;

import com.github.jrubygradle.JRubyPluginExtension;
import com.github.jrubygradle.JRubyPrepare;
import com.github.jrubygradle.api.core.JRubyAwareTask;
import com.github.jrubygradle.api.core.JRubyExecSpec;
import com.github.jrubygradle.internal.JRubyExecUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.GradleVersion;
import org.ysb33r.grolifant.api.StringUtils;

public class JRubyExec
extends JavaExec
implements JRubyAwareTask,
JRubyExecSpec,
GroovyObject {
    public static final String MAIN_CLASS = "org.jruby.Main";
    private static final String USE_JVM_ARGS = "Use jvmArgs / scriptArgs instead";
    @Input
    private boolean inheritRubyEnv;
    private final JRubyPluginExtension jruby;
    private Object script;
    private final List<Object> scriptArgs;
    private final List<Object> jrubyArgs;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public JRubyExec() {
        MetaClass metaClass;
        List list;
        List list2;
        boolean bl;
        this.inheritRubyEnv = bl = false;
        this.scriptArgs = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.jrubyArgs = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        super.setMain(MAIN_CLASS);
        Object object = this.getExtensions().create(JRubyPluginExtension.NAME, JRubyPluginExtension.class, new Object[]{this});
        this.jruby = (JRubyPluginExtension)((Object)ScriptBytecodeAdapter.castToType((Object)object, JRubyPluginExtension.class));
        ((TaskInputsInternal)this.getInputs()).property("jrubyver", (Object)new _closure1((Object)this, (Object)this).curry((Object)this.jruby));
        ((TaskInputsInternal)this.getInputs()).property("gemConfiguration", (Object)new _closure2((Object)this, (Object)this).curry((Object)this.jruby));
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)GradleVersion.current(), (Object)GradleVersion.version((String)"4.10"))) {
            this.dependsOn(new Object[]{((ProjectInternal)this.getProject()).provider((Callable)new _closure3((Object)this, (Object)this).curry((Object)this.jruby))});
        } else {
            ((ProjectInternal)this.getProject()).afterEvaluate(new _closure4((Object)this, (Object)this).curry(new Object[]{this, this.jruby}));
        }
    }

    @Optional
    @Input
    public File getScript() {
        return JRubyExecUtils.resolveScript(this.getProject(), this.script);
    }

    @Input
    public List<String> getScriptArgs() {
        return StringUtils.stringize(this.scriptArgs);
    }

    @Input
    public List<String> getJrubyArgs() {
        return StringUtils.stringize(this.jrubyArgs);
    }

    public void script(Object scr) {
        Object object;
        this.script = object = scr;
    }

    public void setScript(Object scr) {
        Object object;
        this.script = object = scr;
    }

    public void setScriptArgs(Iterable<Object> args) {
        this.scriptArgs.clear();
        DefaultGroovyMethods.addAll(this.scriptArgs, args);
    }

    public void scriptArgs(Object ... args) {
        this.scriptArgs.addAll(DefaultGroovyMethods.toList((Object[])args));
    }

    public void setJrubyArgs(Iterable<Object> args) {
        this.jrubyArgs.clear();
        DefaultGroovyMethods.addAll(this.jrubyArgs, args);
    }

    public void jrubyArgs(Object ... args) {
        this.jrubyArgs.addAll(DefaultGroovyMethods.toList((Object[])args));
    }

    public Provider<File> getGemWorkDir() {
        public final class _getGemWorkDir_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getGemWorkDir_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(JRubyPluginExtension jpe) {
                return ((JRubyPrepare)((Object)ScriptBytecodeAdapter.castToType((Object)((JRubyExec)((AbstractTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractTask.class))).getProject().getTasks().getByName(jpe.getGemPrepareTaskName()), JRubyPrepare.class))).getOutputDir();
            }

            public Object call(JRubyPluginExtension jpe) {
                return this.doCall(jpe);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getGemWorkDir_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Callable resolveGemWorkDir = (Callable)new _getGemWorkDir_closure5((Object)this, (Object)this).curry((Object)this.jruby);
        return ((ProjectInternal)this.getProject()).provider(resolveGemWorkDir);
    }

    @Deprecated
    public String getJrubyVersion() {
        this.deprecated("Use jruby.getJrubyVersion() rather getJrubyVersion()");
        return this.jruby.getJrubyVersion();
    }

    @Deprecated
    public void jrubyVersion(String ver) {
        this.deprecated("Use jruby.jrubyVersion rather jrubyVersion");
        this.jruby.jrubyVersion(ver);
    }

    @Deprecated
    public void configuration(Configuration newConfiguration) {
        this.deprecated("Use jruby.setGemConfiguration() rather than configuration()");
        this.jruby.gemConfiguration(newConfiguration);
    }

    @Deprecated
    public void configuration(String newConfiguration) {
        this.deprecated("Use jruby.setGemConfiguration(newConfiguration) rather than configuration(newConfiguration)");
        this.jruby.gemConfiguration(newConfiguration);
    }

    @Deprecated
    public void setJrubyVersion(String version) {
        this.deprecated("Use jruby.setJrubyVersion rather setJrubyVersion");
        this.jruby.jrubyVersion(version);
    }

    public void exec() {
        File gemDir = (File)ScriptBytecodeAdapter.castToType((Object)this.getGemWorkDir().get(), File.class);
        this.setEnvironment(JRubyExecUtils.prepareJRubyEnvironment(this.getEnvironment(), this.inheritRubyEnv, gemDir));
        super.classpath(new Object[]{this.jruby.getJrubyConfiguration()});
        super.setArgs(this.getArgs());
        super.exec();
    }

    @Input
    public List<String> getArgs() {
        return JRubyExecUtils.buildArgs(ScriptBytecodeAdapter.createList((Object[])new Object[0]), this.jrubyArgs, this.getScript(), this.scriptArgs);
    }

    public JavaExec setMain(String mainClassName) {
        if (ScriptBytecodeAdapter.compareEqual((Object)mainClassName, (Object)MAIN_CLASS)) {
            return super.setMain(mainClassName);
        }
        throw (Throwable)JRubyExec.notAllowed(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mainClassName}, new String[]{"Setting main class for JRuby to ", " is not a valid operation"})));
    }

    public JavaExec setArgs(Iterable<?> applicationArgs) {
        throw (Throwable)JRubyExec.notAllowed(USE_JVM_ARGS);
    }

    public JavaExec args(Object ... args) {
        throw (Throwable)JRubyExec.notAllowed(USE_JVM_ARGS);
    }

    public JavaExecSpec args(Iterable<?> args) {
        throw (Throwable)JRubyExec.notAllowed(USE_JVM_ARGS);
    }

    private static UnsupportedOperationException notAllowed(String msg) {
        return new UnsupportedOperationException(msg);
    }

    private void deprecated(String message) {
        this.getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getName(), message}, new String[]{"Deprecated method in task ", ": ", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JRubyExec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public boolean getInheritRubyEnv() {
        return this.inheritRubyEnv;
    }

    @Generated
    public boolean isInheritRubyEnv() {
        return this.inheritRubyEnv;
    }

    @Generated
    public void setInheritRubyEnv(boolean bl) {
        this.inheritRubyEnv = bl;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(JRubyPluginExtension jruby) {
            return jruby.getJrubyVersion();
        }

        public Object call(JRubyPluginExtension jruby) {
            return this.doCall(jruby);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(JRubyPluginExtension jruby) {
            return jruby.getGemConfiguration();
        }

        public Object call(JRubyPluginExtension jruby) {
            return this.doCall(jruby);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure3
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure3(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(JRubyPluginExtension jpe) {
            return ((JRubyExec)((AbstractTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractTask.class))).getProject().getTasks().getByName(jpe.getGemPrepareTaskName());
        }

        public Object call(JRubyPluginExtension jpe) {
            return this.doCall(jpe);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure4
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure4(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Task t, JRubyPluginExtension jpe) {
            return t.dependsOn(new Object[]{jpe.getGemPrepareTaskName()});
        }

        public Object call(Task t, JRubyPluginExtension jpe) {
            return this.doCall(t, jpe);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure4.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

