/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrubygradle;

import com.github.jrubygradle.UninitialisedParameterException;
import com.github.jrubygradle.api.core.JRubyAwareTask;
import com.github.jrubygradle.api.core.RepositoryHandlerExtension;
import com.github.jrubygradle.internal.JRubyPrepareUtils;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.util.List;
import java.util.concurrent.Callable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.ysb33r.grolifant.api.AbstractCombinedProjectTaskExtension;
import org.ysb33r.grolifant.api.StringUtils;

public class JRubyPluginExtension
extends AbstractCombinedProjectTaskExtension {
    public static final String DEFAULT_JRUBY_VERSION = "9.2.9.0";
    public static final String NAME = "jruby";
    private static final String JRUBY_COMPLETE_DEPENDENCY = "org.jruby:jruby-complete";
    private Object jrubyVersion;
    private Provider<Configuration> gemConfiguration;
    private String gemPrepareTaskName;
    private boolean taskResolutionStrategiesOnly;
    private final List<Action<ResolutionStrategy>> resolutionsStrategies;
    private boolean defaultRepositoriesCalled;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public JRubyPluginExtension(Project p) {
        super(p);
        boolean bl;
        List list;
        boolean bl2;
        this.taskResolutionStrategiesOnly = bl2 = false;
        this.resolutionsStrategies = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.defaultRepositoriesCalled = bl = false;
        String string = DEFAULT_JRUBY_VERSION;
        this.jrubyVersion = string;
    }

    public JRubyPluginExtension(JRubyAwareTask t) {
        super((Task)t, NAME);
        boolean bl;
        List list;
        boolean bl2;
        this.taskResolutionStrategiesOnly = bl2 = false;
        this.resolutionsStrategies = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.defaultRepositoriesCalled = bl = false;
    }

    public String getJrubyVersion() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getTask())) {
            return DefaultTypeTransformation.booleanUnbox((Object)this.jrubyVersion) ? StringUtils.stringize((Object)this.jrubyVersion) : this.getExtFromProject().getJrubyVersion();
        }
        return StringUtils.stringize((Object)this.jrubyVersion);
    }

    public void setJrubyVersion(Object v) {
        Object object;
        this.jrubyVersion = object = v;
    }

    public void jrubyVersion(Object v) {
        Object object;
        this.jrubyVersion = object = v;
    }

    @Deprecated
    public String getDefaultVersion() {
        this.deprecated("Use getJrubyVersion() rather than getDefaultVersion()");
        return this.getJrubyVersion();
    }

    @Deprecated
    public void setDefaultVersion(String ver) {
        this.deprecated("Use setJrubyVersion(ver) rather than setDefaultVersion()");
        this.setJrubyVersion(ver);
    }

    public void defaultVersion(String newDefaultVersion) {
        this.deprecated("Use jrubyVersion(ver) rather than defaultVerion(ver)");
        this.setJrubyVersion(newDefaultVersion);
    }

    @Deprecated
    public void setDefaultRepositories(boolean value) {
        if (!this.defaultRepositoriesCalled) {
            boolean bl;
            this.defaultRepositoriesCalled = bl = true;
            if (value) {
                this.deprecated(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"jruby.defaultRepositories will not be supported in a future version.", (CharSequence)"It is recommended that you explicitly declare your repositories rather than rely on "), (CharSequence)"this functionality."));
                this.getProject().getRepositories().jcenter();
                ((RepositoryHandlerExtension)((ExtensionAware)ScriptBytecodeAdapter.castToType((Object)this.getProject().getRepositories(), ExtensionAware.class)).getExtensions().getByType(RepositoryHandlerExtension.class)).gems();
            } else {
                this.deprecated(StringGroovyMethods.plus((String)"jruby.defaultRepositories are no longer switched on by default - you can safely remove ", (CharSequence)"this setting."));
            }
        }
    }

    public void clearResolutionStrategies() {
        this.resolutionsStrategies.clear();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getTask())) {
            boolean bl;
            this.taskResolutionStrategiesOnly = bl = true;
        }
    }

    public void resolutionStrategy(Action<ResolutionStrategy> strategy) {
        this.resolutionsStrategies.add(strategy);
    }

    public void resolutionStrategy(@DelegatesTo(value=ResolutionStrategy.class) Closure strategy) {
        this.resolutionsStrategies.add((Action<ResolutionStrategy>)((Action)ScriptBytecodeAdapter.asType((Object)strategy, Action.class)));
    }

    public Configuration getJrubyConfiguration() {
        String jrubyVer = this.getJrubyVersion();
        String jrubyCompleteDep = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{JRUBY_COMPLETE_DEPENDENCY, jrubyVer}, new String[]{"", ":", ""}));
        List deps = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.createDependency(jrubyCompleteDep)});
        Reference configuration = new Reference((Object)this.getProject().getConfigurations().detachedConfiguration((Dependency[])ScriptBytecodeAdapter.asType((Object)deps.toArray(), Dependency[].class)));
        public final class _getJrubyConfiguration_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference configuration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getJrubyConfiguration_closure1(Object _outerInstance, Object _thisObject, Reference configuration) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.configuration = reference = configuration;
            }

            public Object doCall(Object it) {
                return ((Configuration)this.configuration.get()).resolutionStrategy((Action)ScriptBytecodeAdapter.castToType((Object)it, Action.class));
            }

            public Configuration getConfiguration() {
                return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), Configuration.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getJrubyConfiguration_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.getAllResolutionStrategyActions(), (Closure)new _getJrubyConfiguration_closure1((Object)this, (Object)this, configuration));
        return (Configuration)configuration.get();
    }

    public void setGemConfiguration(Object c) {
        Reference c2 = new Reference(c);
        Object object = c2.get();
        if (ScriptBytecodeAdapter.isCase((Object)object, Configuration.class)) {
            Provider provider;
            public final class _setGemConfiguration_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference c;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _setGemConfiguration_closure2(Object _outerInstance, Object _thisObject, Reference c) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.c = reference = c;
                }

                public Object doCall() {
                    return this.c.get();
                }

                public Object getC() {
                    return this.c.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _setGemConfiguration_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            this.gemConfiguration = provider = this.getProject().provider((Callable)((Object)new _setGemConfiguration_closure2((Object)this, (Object)this, c2)));
            this.registerPrepareTask(((Configuration)ScriptBytecodeAdapter.castToType((Object)c2.get(), Configuration.class)).getName());
        } else if (ScriptBytecodeAdapter.isCase((Object)object, CharSequence.class)) {
            Provider provider;
            public final class _setGemConfiguration_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference c;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _setGemConfiguration_closure3(Object _outerInstance, Object _thisObject, Reference c) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.c = reference = c;
                }

                public Object doCall() {
                    return ((Project)InvokerHelper.invokeMethodSafe((Object)((Object)((JRubyPluginExtension)((Object)this.getThisObject()))), (String)"getProject", (Object)new Object[0])).getConfigurations().getByName(DefaultGroovyMethods.toString((Object)this.c.get()));
                }

                public Object getC() {
                    return this.c.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _setGemConfiguration_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            this.gemConfiguration = provider = this.getProject().provider((Callable)((Object)new _setGemConfiguration_closure3((Object)this, (Object)this, c2)));
            this.registerPrepareTask(DefaultGroovyMethods.toString((Object)c2.get()));
        } else if (ScriptBytecodeAdapter.isCase((Object)object, Provider.class)) {
            Provider provider;
            this.gemConfiguration = provider = (Provider)ScriptBytecodeAdapter.castToType((Object)c2.get(), Provider.class);
            this.registerPrepareTask(((Configuration)((Provider)ScriptBytecodeAdapter.castToType((Object)c2.get(), Provider.class)).get()).getName());
        } else {
            throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{c2.get().getClass().getCanonicalName()}, new String[]{"", " is not a supported type for converting to a Configuration"})));
        }
    }

    public void gemConfiguration(Object c) {
        this.setGemConfiguration(c);
    }

    public Configuration getGemConfiguration() {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.getTask())) {
            if (this.gemConfiguration == null) {
                throw (Throwable)new UninitialisedParameterException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{NAME}, new String[]{"GEM configuration has not been set. Use ", ".setConfiguration()"})));
            }
            return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.gemConfiguration.get(), Configuration.class);
        }
        if (DefaultTypeTransformation.booleanUnbox(this.gemConfiguration)) {
            return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.gemConfiguration.get(), Configuration.class);
        }
        return this.getExtFromProject().getGemConfiguration();
    }

    public String getGemPrepareTaskName() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getTask())) {
            String string = this.gemPrepareTaskName;
            return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.getExtFromProject().getGemPrepareTaskName();
        }
        return this.gemPrepareTaskName;
    }

    protected List<Action<ResolutionStrategy>> getAllResolutionStrategyActions() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getTask())) {
            if (this.taskResolutionStrategiesOnly) {
                return this.resolutionsStrategies;
            }
            return DefaultGroovyMethods.plus(this.getExtFromProject().getAllResolutionStrategyActions(), this.resolutionsStrategies);
        }
        return this.resolutionsStrategies;
    }

    private JRubyPluginExtension getExtFromProject() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.getTask()) ? (JRubyPluginExtension)((Object)ScriptBytecodeAdapter.castToType((Object)this.getProjectExtension(), JRubyPluginExtension.class)) : this;
    }

    private void deprecated(String msg) {
        this.getProject().getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{NAME, msg}, new String[]{"Deprecated feature in ", " extension. ", ""})));
    }

    private Dependency createDependency(String notation, Closure configurator) {
        if (DefaultTypeTransformation.booleanUnbox((Object)configurator)) {
            return this.getProject().getDependencies().create((Object)notation, configurator);
        }
        return this.getProject().getDependencies().create((Object)notation);
    }

    private void registerPrepareTask(String configurationName) {
        String string;
        JRubyPrepareUtils.registerPrepareTask(this.getProject(), configurationName);
        this.gemPrepareTaskName = string = JRubyPrepareUtils.taskName(configurationName);
    }

    @Generated
    private Dependency createDependency(String notation) {
        return this.createDependency(notation, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JRubyPluginExtension.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }
}

