/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrubygradle.internal;

import com.github.jrubygradle.JRubyPluginExtension;
import com.github.jrubygradle.api.gems.GemOverwriteAction;
import com.github.jrubygradle.api.gems.GemUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.ysb33r.grolifant.api.OperatingSystem;
import org.ysb33r.grolifant.api.StringUtils;

public class JRubyExecUtils
implements GroovyObject {
    public static final List<String> FILTERED_ENV_KEYS;
    public static final String DEFAULT_JRUBYEXEC_CONFIG = "gems";
    private static final String JRUBY_COMPLETE = "jruby-complete";
    private static final String BINPATH_FLAG = "-S";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public JRubyExecUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Set<File> classpathFromConfiguration(Configuration cfg) {
        public final class _classpathFromConfiguration_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _classpathFromConfiguration_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File f) {
                return f.getName().startsWith(JRUBY_COMPLETE);
            }

            public Object call(File f) {
                return this.doCall(f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _classpathFromConfiguration_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.findAll((Set)cfg.getFiles(), (Closure)new _classpathFromConfiguration_closure1(JRubyExecUtils.class, JRubyExecUtils.class));
    }

    public static File jrubyJar(Configuration cfg) {
        public final class _jrubyJar_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _jrubyJar_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((File)it).getName().startsWith(JRUBY_COMPLETE);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _jrubyJar_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (File)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)cfg.getFiles(), (Closure)new _jrubyJar_closure2(JRubyExecUtils.class, JRubyExecUtils.class)), File.class);
    }

    public static String jrubyJarVersion(File jar) {
        CallSite[] callSiteArray = JRubyExecUtils.$getCallSiteArray();
        Matcher matches = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)callSiteArray[0].callGetProperty((Object)jar), (Object)new GStringImpl(new Object[]{JRUBY_COMPLETE}, new String[]{"", "-(.+)\\.jar"})), Matcher.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)matches)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[1].call(callSiteArray[2].call((Object)matches, (Object)0), (Object)1));
        }
        return ShortTypeHandling.castToString(null);
    }

    @Deprecated
    public static Map jrubyJarVersionTriple(File jar) {
        CallSite[] callSiteArray = JRubyExecUtils.$getCallSiteArray();
        String version = ShortTypeHandling.castToString((Object)callSiteArray[3].callStatic(JRubyExecUtils.class, (Object)jar));
        if (!DefaultTypeTransformation.booleanUnbox((Object)version)) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        Matcher matches = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)version, (Object)"(\\d{1,2})\\.(\\d{1,3})\\.(\\d{1,3}).*"), Matcher.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)matches)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[5].call(callSiteArray[6].call((Object)matches, (Object)0)), (Object)4) : !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call((Object)matches)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[8].call(callSiteArray[9].call((Object)matches, (Object)0)), (Object)4)) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"major", callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call((Object)matches, (Object)0), (Object)1)), "minor", callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call((Object)matches, (Object)0), (Object)2)), "patchlevel", callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call((Object)matches, (Object)0), (Object)3))});
    }

    public static File resolveScript(Project project, Object script) {
        if (DefaultTypeTransformation.booleanUnbox((Object)script)) {
            File intermediate = script instanceof File ? (File)ScriptBytecodeAdapter.castToType((Object)script, File.class) : new File(StringUtils.stringize((Object)script));
            if (intermediate.isAbsolute()) {
                return intermediate;
            }
            return DefaultTypeTransformation.booleanUnbox((Object)intermediate.getParentFile()) ? project.file(script) : intermediate;
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static List<String> buildArgs(List<Object> jrubyArgs, File script, List<Object> scriptArgs) {
        return JRubyExecUtils.buildArgs(ScriptBytecodeAdapter.createList((Object[])new Object[0]), jrubyArgs, script, scriptArgs);
    }

    public static List<String> buildArgs(List<Object> extra, List<Object> jrubyArgs, File script, List<Object> scriptArgs) {
        List<Object> cmdArgs = extra;
        cmdArgs.add("-rjars/setup");
        boolean hasInlineScript = jrubyArgs.contains("-e");
        boolean useBinPath = jrubyArgs.contains(BINPATH_FLAG);
        if (!hasInlineScript && DefaultTypeTransformation.booleanUnbox((Object)script) && !jrubyArgs.contains(BINPATH_FLAG)) {
            boolean bl;
            jrubyArgs.add(BINPATH_FLAG);
            useBinPath = bl = true;
        }
        cmdArgs.addAll(jrubyArgs);
        if (useBinPath && script != null) {
            if (script.isAbsolute() && !script.exists()) {
                throw (Throwable)new InvalidUserDataException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{script}, new String[]{"", " does not exist"})));
            }
            cmdArgs.add(script.toString());
        } else if (script == null) {
            if (useBinPath && jrubyArgs.size() <= 1) {
                throw (Throwable)new InvalidUserDataException("No `script` property defined and no inline script provided");
            }
            if (jrubyArgs.isEmpty()) {
                throw (Throwable)new InvalidUserDataException("Cannot build JRuby execution arguments with either `script` or `jrubyArgs` set");
            }
        }
        cmdArgs.addAll(scriptArgs);
        return StringUtils.stringize(cmdArgs);
    }

    public static String pathVar() {
        return OperatingSystem.current().getPathVar();
    }

    public static String prepareWorkingPath(File gemWorkDir, String originalPath) {
        File path = new File(gemWorkDir, "bin");
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)path.getAbsolutePath(), (Object)Character.valueOf(File.pathSeparatorChar)), (CharSequence)originalPath);
    }

    public static void updateJRubyDependenciesForConfiguration(Project project, String configuration, String version) {
        Configuration c = (Configuration)ScriptBytecodeAdapter.castToType((Object)project.getConfigurations().findByName(configuration), Configuration.class);
        public final class _updateJRubyDependenciesForConfiguration_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateJRubyDependenciesForConfiguration_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Dependency)it).getName(), (Object)JRUBY_COMPLETE);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateJRubyDependenciesForConfiguration_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find((Collection)c.getDependencies(), (Closure)new _updateJRubyDependenciesForConfiguration_closure3(JRubyExecUtils.class, JRubyExecUtils.class)))) {
            project.getDependencies().add(configuration, (Object)new GStringImpl(new Object[]{version}, new String[]{"org.jruby:jruby-complete:", ""}));
        }
    }

    public static void prepareDependencies(Project project, File gemWorkDir, JRubyPluginExtension jruby, Configuration gemConfiguration, GemOverwriteAction overwrite) {
        File gemDir = gemWorkDir.getAbsoluteFile();
        gemDir.mkdirs();
        GemUtils.extractGems((Project)project, (Configuration)jruby.getJrubyConfiguration(), (Configuration)gemConfiguration, (File)gemDir, (GemOverwriteAction)overwrite);
        GemUtils.setupJars((Configuration)gemConfiguration, (File)gemDir, (GemOverwriteAction)overwrite);
    }

    public static Map<String, Object> prepareJRubyEnvironment(Map<String, Object> presetEnvironment, boolean inheritRubyEnv, File gemWorkDir) {
        Reference inheritRubyEnv2 = new Reference((Object)inheritRubyEnv);
        LinkedHashMap preparedEnv = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        public final class _prepareJRubyEnvironment_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference inheritRubyEnv;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _prepareJRubyEnvironment_closure4(Object _outerInstance, Object _thisObject, Reference inheritRubyEnv) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.inheritRubyEnv = reference = inheritRubyEnv;
            }

            public Object doCall(String key, Object value) {
                return DefaultTypeTransformation.booleanUnbox((Object)this.inheritRubyEnv.get()) || !(DefaultTypeTransformation.booleanUnbox((Object)(FILTERED_ENV_KEYS == null ? Boolean.valueOf(key == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(FILTERED_ENV_KEYS, (Object)key)))) || key.matches("rvm.*"));
            }

            public Object call(String key, Object value) {
                return this.doCall(key, value);
            }

            public boolean getInheritRubyEnv() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.inheritRubyEnv.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _prepareJRubyEnvironment_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        preparedEnv.putAll(DefaultGroovyMethods.findAll(presetEnvironment, (Closure)new _prepareJRubyEnvironment_closure4(JRubyExecUtils.class, JRubyExecUtils.class, inheritRubyEnv2)));
        preparedEnv.putAll(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"JBUNDLE_SKIP", true, "JARS_SKIP", true, "PATH", JRubyExecUtils.prepareWorkingPath(gemWorkDir, System.getenv(JRubyExecUtils.pathVar())), "GEM_HOME", gemWorkDir.getAbsolutePath(), "GEM_PATH", gemWorkDir.getAbsolutePath(), "JARS_HOME", new File(gemWorkDir.getAbsoluteFile(), "jars"), "JARS_LOCK", new File(gemWorkDir.getAbsoluteFile(), "Jars.lock")}));
        return preparedEnv;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JRubyExecUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        List list;
        FILTERED_ENV_KEYS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"GEM_PATH", "RUBY_VERSION", "GEM_HOME"});
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "name";
        stringArray[1] = "getAt";
        stringArray[2] = "getAt";
        stringArray[3] = "jrubyJarVersion";
        stringArray[4] = "matches";
        stringArray[5] = "size";
        stringArray[6] = "getAt";
        stringArray[7] = "matches";
        stringArray[8] = "size";
        stringArray[9] = "getAt";
        stringArray[10] = "toInteger";
        stringArray[11] = "getAt";
        stringArray[12] = "getAt";
        stringArray[13] = "toInteger";
        stringArray[14] = "getAt";
        stringArray[15] = "getAt";
        stringArray[16] = "toInteger";
        stringArray[17] = "getAt";
        stringArray[18] = "getAt";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[19];
        JRubyExecUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(JRubyExecUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = JRubyExecUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

