/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.jaxrs;

import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class JaxrsParameterExtension
extends AbstractSwaggerExtension
implements SwaggerExtension {
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = null;
        for (Annotation annotation : annotations) {
            parameter = JaxrsParameterExtension.getParameter(type, parameter, annotation);
        }
        if (parameter != null) {
            parameters.add(parameter);
        }
        return parameters;
    }

    public static Parameter getParameter(Type type, Parameter parameter, Annotation annotation) {
        QueryParam param;
        String defaultValue = "";
        if (annotation instanceof DefaultValue) {
            DefaultValue defaultValueAnnotation = (DefaultValue)annotation;
            defaultValue = defaultValueAnnotation.value();
        }
        if (annotation instanceof QueryParam) {
            String parameterType;
            Property schema;
            param = (QueryParam)annotation;
            QueryParameter qp = (QueryParameter)new QueryParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                qp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                qp.setProperty(schema);
            }
            if ((parameterType = qp.getType()) == null || parameterType.equals("ref")) {
                qp.setType("string");
            }
            parameter = qp;
        } else if (annotation instanceof PathParam) {
            String parameterType;
            Property schema;
            param = (PathParam)annotation;
            PathParameter pp = (PathParameter)new PathParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                pp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                pp.setProperty(schema);
            }
            if ((parameterType = pp.getType()) == null || parameterType.equals("ref")) {
                pp.setType("string");
            }
            parameter = pp;
        } else if (annotation instanceof HeaderParam) {
            String parameterType;
            param = (HeaderParam)annotation;
            HeaderParameter hp = (HeaderParameter)new HeaderParameter().name(param.value());
            hp.setDefaultValue(defaultValue);
            Property schema = ModelConverters.getInstance().readAsProperty(type);
            if (schema != null) {
                hp.setProperty(schema);
            }
            if ((parameterType = hp.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
                hp.setType("string");
            }
            parameter = hp;
        } else if (annotation instanceof CookieParam) {
            String parameterType;
            Property schema;
            param = (CookieParam)annotation;
            CookieParameter cp = (CookieParameter)new CookieParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                cp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                cp.setProperty(schema);
            }
            if ((parameterType = cp.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
                cp.setType("string");
            }
            parameter = cp;
        } else if (annotation instanceof FormParam) {
            String parameterType;
            Property schema;
            param = (FormParam)annotation;
            FormParameter fp = (FormParameter)new FormParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                fp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                fp.setProperty(schema);
            }
            if ((parameterType = fp.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
                fp.setType("string");
            }
            parameter = fp;
        }
        return parameter;
    }
}

