/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.mavenplugin.SecurityDefinition;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.core.annotation.AnnotationUtils;

public class ApiSource {
    @Parameter(required=true)
    private List<String> locations;
    @Parameter
    private Info info;
    @Parameter
    private String basePath;
    private String host;
    private List<String> schemes;
    @Parameter
    private String templatePath;
    @Parameter
    private String outputPath;
    @Parameter
    private String outputFormats;
    @Parameter
    private String swaggerDirectory;
    @Parameter
    private String swaggerFileName;
    @Parameter
    private boolean attachSwaggerArtifact;
    @Parameter
    private String swaggerUIDocBasePath;
    @Parameter
    private String modelSubstitute;
    @Parameter
    private String apiSortComparator;
    @Parameter
    private String swaggerInternalFilter;
    @Parameter
    private String swaggerApiReader;
    @Parameter
    private List<String> swaggerExtensions;
    @Parameter
    private boolean springmvc;
    @Parameter
    private boolean useJAXBAnnotationProcessor;
    @Parameter
    private boolean useJAXBAnnotationProcessorAsPrimary = true;
    @Parameter
    private String swaggerSchemaConverter;
    @Parameter
    private List<SecurityDefinition> securityDefinitions;
    @Parameter
    private List<String> typesToSkip = new ArrayList<String>();
    @Parameter
    private List<String> apiModelPropertyAccessExclusions = new ArrayList<String>();
    @Parameter
    private boolean jsonExampleValues = false;
    @Parameter
    private File descriptionFile;
    @Parameter
    private List<String> modelConverters;

    public Set<Class<?>> getValidClasses(Class<? extends Annotation> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        if (this.getLocations() == null) {
            Set c = new Reflections("", new Scanner[0]).getTypesAnnotatedWith(clazz, true);
            classes.addAll(c);
            Set inherited = new Reflections("", new Scanner[0]).getTypesAnnotatedWith(clazz);
            classes.addAll(inherited);
        } else {
            for (String location : this.locations) {
                Set c = new Reflections(location, new Scanner[0]).getTypesAnnotatedWith(clazz, true);
                classes.addAll(c);
                Set inherited = new Reflections(location, new Scanner[0]).getTypesAnnotatedWith(clazz);
                classes.addAll(inherited);
            }
        }
        return classes;
    }

    public List<String> getApiModelPropertyAccessExclusions() {
        return this.apiModelPropertyAccessExclusions;
    }

    public void setApiModelPropertyExclusions(List<String> apiModelPropertyAccessExclusions) {
        this.apiModelPropertyAccessExclusions = apiModelPropertyAccessExclusions;
    }

    public List<SecurityDefinition> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public List<String> getTypesToSkip() {
        return this.typesToSkip;
    }

    public void setTypesToSkip(List<String> typesToSkip) {
        this.typesToSkip = typesToSkip;
    }

    public void setSecurityDefinitions(List<SecurityDefinition> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public Info getInfo() {
        if (this.info == null) {
            this.setInfoFromAnnotation();
        }
        return this.info;
    }

    private void setInfoFromAnnotation() {
        Info resultInfo = new Info();
        for (Class<?> aClass : this.getValidClasses(SwaggerDefinition.class)) {
            SwaggerDefinition swaggerDefinition = (SwaggerDefinition)AnnotationUtils.findAnnotation(aClass, SwaggerDefinition.class);
            io.swagger.annotations.Info infoAnnotation = swaggerDefinition.info();
            Info info = new Info().title(infoAnnotation.title()).description(infoAnnotation.description()).version(infoAnnotation.version()).termsOfService(infoAnnotation.termsOfService()).license(this.from(infoAnnotation.license())).contact(this.from(infoAnnotation.contact()));
            resultInfo.mergeWith(info);
        }
        this.info = resultInfo;
    }

    private Contact from(io.swagger.annotations.Contact contactAnnotation) {
        return new Contact().name(contactAnnotation.name()).email(contactAnnotation.email()).url(contactAnnotation.url());
    }

    private io.swagger.models.License from(License licenseAnnotation) {
        return new io.swagger.models.License().name(licenseAnnotation.name()).url(licenseAnnotation.url());
    }

    private void setBasePathFromAnnotation() {
        for (Class<?> aClass : this.getValidClasses(SwaggerDefinition.class)) {
            SwaggerDefinition swaggerDefinition = (SwaggerDefinition)AnnotationUtils.findAnnotation(aClass, SwaggerDefinition.class);
            this.basePath = swaggerDefinition.basePath();
        }
    }

    private void setHostFromAnnotation() {
        for (Class<?> aClass : this.getValidClasses(SwaggerDefinition.class)) {
            SwaggerDefinition swaggerDefinition = (SwaggerDefinition)AnnotationUtils.findAnnotation(aClass, SwaggerDefinition.class);
            this.host = swaggerDefinition.host();
        }
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputFormats() {
        return this.outputFormats;
    }

    public void setOutputFormats(String outputFormats) {
        this.outputFormats = outputFormats;
    }

    public String getBasePath() {
        if (this.basePath == null) {
            this.setBasePathFromAnnotation();
        }
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getSwaggerDirectory() {
        return this.swaggerDirectory;
    }

    public void setSwaggerDirectory(String swaggerDirectory) {
        this.swaggerDirectory = swaggerDirectory;
    }

    public String getSwaggerFileName() {
        return this.swaggerFileName;
    }

    public void setSwaggerFileName(String swaggerFileName) {
        this.swaggerFileName = swaggerFileName;
    }

    public boolean isAttachSwaggerArtifact() {
        return this.attachSwaggerArtifact;
    }

    public void setAttachSwaggerArtifact(boolean attachSwaggerArtifact) {
        this.attachSwaggerArtifact = attachSwaggerArtifact;
    }

    public void setSwaggerUIDocBasePath(String swaggerUIDocBasePath) {
        this.swaggerUIDocBasePath = swaggerUIDocBasePath;
    }

    public String getSwaggerUIDocBasePath() {
        return this.swaggerUIDocBasePath;
    }

    public String getHost() {
        if (this.host == null) {
            this.setHostFromAnnotation();
        }
        return this.host;
    }

    public void setModelSubstitute(String modelSubstitute) {
        this.modelSubstitute = modelSubstitute;
    }

    public String getSwaggerInternalFilter() {
        return this.swaggerInternalFilter;
    }

    public void setSwaggerInternalFilter(String swaggerInternalFilter) {
        this.swaggerInternalFilter = swaggerInternalFilter;
    }

    public String getSwaggerApiReader() {
        return this.swaggerApiReader;
    }

    public void setSwaggerApiReader(String swaggerApiReader) {
        this.swaggerApiReader = swaggerApiReader;
    }

    public List<String> getSwaggerExtensions() {
        return this.swaggerExtensions;
    }

    public void setSwaggerExtensions(List<String> swaggerExtensions) {
        this.swaggerExtensions = swaggerExtensions;
    }

    public String getApiSortComparator() {
        return this.apiSortComparator;
    }

    public void setApiSortComparator(String apiSortComparator) {
        this.apiSortComparator = apiSortComparator;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<String> schemes) {
        this.schemes = schemes;
    }

    public String getModelSubstitute() {
        return this.modelSubstitute;
    }

    public boolean isSpringmvc() {
        return this.springmvc;
    }

    public void setSpringmvc(boolean springmvc) {
        this.springmvc = springmvc;
    }

    public String getSwaggerSchemaConverter() {
        return this.swaggerSchemaConverter;
    }

    public void setSwaggerSchemaConverter(String swaggerSchemaConverter) {
        this.swaggerSchemaConverter = swaggerSchemaConverter;
    }

    public boolean isJsonExampleValues() {
        return this.jsonExampleValues;
    }

    public void setJsonExampleValues(boolean jsonExampleValues) {
        this.jsonExampleValues = jsonExampleValues;
    }

    public boolean isUseJAXBAnnotationProcessor() {
        return this.useJAXBAnnotationProcessor;
    }

    public void setUseJAXBAnnotationProcessor(boolean useJAXBAnnotationProcessor) {
        this.useJAXBAnnotationProcessor = useJAXBAnnotationProcessor;
    }

    public boolean isUseJAXBAnnotationProcessorAsPrimary() {
        return this.useJAXBAnnotationProcessorAsPrimary;
    }

    public void setUseJAXBAnnotationProcessorAsPrimary(boolean useJAXBAnnotationProcessorAsPrimary) {
        this.useJAXBAnnotationProcessorAsPrimary = useJAXBAnnotationProcessorAsPrimary;
    }

    public File getDescriptionFile() {
        return this.descriptionFile;
    }

    public void setDescriptionFile(File descriptionFile) {
        this.descriptionFile = descriptionFile;
    }

    public List<String> getModelConverters() {
        return this.modelConverters;
    }

    public void setModelConverters(List<String> modelConverters) {
        this.modelConverters = modelConverters;
    }
}

