/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.reader.AbstractReader;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import com.github.kongchen.swagger.docgen.reader.ResponseContainerConverter;
import com.github.kongchen.swagger.docgen.spring.SpringResource;
import com.github.kongchen.swagger.docgen.spring.SpringSwaggerExtension;
import com.github.kongchen.swagger.docgen.util.SpringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

public class SpringMvcApiReader
extends AbstractReader
implements ClassSwaggerReader {
    private static final ResponseContainerConverter RESPONSE_CONTAINER_CONVERTER = new ResponseContainerConverter();
    private String resourcePath;

    public SpringMvcApiReader(Swagger swagger, Log log) {
        super(swagger, log);
    }

    @Override
    protected void updateExtensionChain() {
        ArrayList<SpringSwaggerExtension> extensions = new ArrayList<SpringSwaggerExtension>();
        extensions.add(new SpringSwaggerExtension());
        SwaggerExtensions.setExtensions(extensions);
    }

    @Override
    public Swagger read(Set<Class<?>> classes) throws GenerateException {
        Map<String, SpringResource> resourceMap = this.generateResourceMap(classes);
        for (String str : resourceMap.keySet()) {
            SpringResource resource = resourceMap.get(str);
            this.read(resource);
        }
        return this.swagger;
    }

    public Swagger read(SpringResource resource) {
        if (this.swagger == null) {
            this.swagger = new Swagger();
        }
        List<Method> methods = resource.getMethods();
        HashMap<String, Tag> tags = new HashMap();
        ArrayList<SecurityRequirement> resourceSecurities = new ArrayList();
        Class<?> controller = resource.getControllerClass();
        RequestMapping controllerRM = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(controller, RequestMapping.class);
        String[] controllerProduces = new String[]{};
        String[] controllerConsumes = new String[]{};
        if (controllerRM != null) {
            controllerConsumes = controllerRM.consumes();
            controllerProduces = controllerRM.produces();
        }
        if (controller.isAnnotationPresent(Api.class)) {
            Api api = (Api)AnnotatedElementUtils.findMergedAnnotation(controller, Api.class);
            if (!this.canReadApi(false, api)) {
                return this.swagger;
            }
            tags = this.updateTagsForApi(null, api);
            resourceSecurities = this.getSecurityRequirements(api);
        }
        this.resourcePath = resource.getControllerMapping();
        Map<String, List<Method>> apiMethodMap = this.collectApisByRequestMapping(methods);
        for (String path : apiMethodMap.keySet()) {
            for (Method method : apiMethodMap.get(path)) {
                ApiOperation apiOperation;
                RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
                if (requestMapping == null || (apiOperation = (ApiOperation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiOperation.class)) != null && apiOperation.hidden()) continue;
                HashMap<String, String> regexMap = new HashMap<String, String>();
                String operationPath = this.parseOperationPath(path, regexMap);
                for (RequestMethod requestMethod : requestMapping.method()) {
                    String httpMethod = requestMethod.toString().toLowerCase();
                    Operation operation = this.parseMethod(method);
                    this.updateOperationParameters(new ArrayList<Parameter>(), regexMap, operation);
                    this.updateOperationProtocols(apiOperation, operation);
                    String[] apiProduces = requestMapping.produces();
                    String[] apiConsumes = requestMapping.consumes();
                    apiProduces = apiProduces.length == 0 ? controllerProduces : apiProduces;
                    apiConsumes = apiConsumes.length == 0 ? controllerConsumes : apiConsumes;
                    apiConsumes = this.updateOperationConsumes(new String[0], apiConsumes, operation);
                    apiProduces = this.updateOperationProduces(new String[0], apiProduces, operation);
                    this.updateTagsForOperation(operation, apiOperation);
                    this.updateOperation(apiConsumes, apiProduces, tags, resourceSecurities, operation);
                    this.updatePath(operationPath, httpMethod, operation);
                }
            }
        }
        return this.swagger;
    }

    private Operation parseMethod(Method method) {
        int responseCode = 200;
        Operation operation = new Operation();
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        Object responseClass = null;
        ArrayList<String> produces = new ArrayList<String>();
        ArrayList<Object> consumes = new ArrayList<Object>();
        String responseContainer = null;
        String operationId = method.getName();
        Map<String, Property> defaultResponseHeaders = null;
        ApiOperation apiOperation = (ApiOperation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiOperation.class);
        if (apiOperation != null) {
            if (apiOperation.hidden()) {
                return null;
            }
            if (!apiOperation.nickname().isEmpty()) {
                operationId = apiOperation.nickname();
            }
            defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            Set<Map<String, Object>> customExtensions = this.parseCustomExtensions(apiOperation.extensions());
            for (Map<String, Object> map : customExtensions) {
                if (map == null) continue;
                for (Map.Entry<String, Object> map2 : map.entrySet()) {
                    operation.setVendorExtension(map2.getKey().startsWith("x-") ? map2.getKey() : "x-" + map2.getKey(), map2.getValue());
                }
            }
            if (!apiOperation.response().equals(Void.class)) {
                responseClass = apiOperation.response();
            }
            if (!apiOperation.responseContainer().isEmpty()) {
                responseContainer = apiOperation.responseContainer();
            }
            ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
            for (Authorization auth : apiOperation.authorizations()) {
                if (auth.value().isEmpty()) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : auth.scopes()) {
                    if (scope.scope().isEmpty()) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
            for (SecurityRequirement sec : securities) {
                operation.security(sec);
            }
            responseCode = apiOperation.code();
        }
        if (responseClass == null) {
            this.LOG.info((CharSequence)("picking up response class from method " + method));
            responseClass = method.getGenericReturnType();
        }
        if (responseClass instanceof ParameterizedType && ResponseEntity.class.equals((Object)((ParameterizedType)responseClass).getRawType())) {
            responseClass = ((ParameterizedType)responseClass).getActualTypeArguments()[0];
        }
        boolean hasApiAnnotation = false;
        if (responseClass instanceof Class) {
            boolean bl = hasApiAnnotation = AnnotationUtils.findAnnotation((Class)((Class)responseClass), Api.class) != null;
        }
        if (!(responseClass == null || responseClass.equals(Void.class) || responseClass.equals(ResponseEntity.class) || hasApiAnnotation)) {
            Object models;
            if (this.isPrimitive((Type)responseClass)) {
                Property property = ModelConverters.getInstance().readAsProperty((Type)responseClass);
                if (property != null) {
                    Property property2 = RESPONSE_CONTAINER_CONVERTER.withResponseContainer(responseContainer, property);
                    operation.response(responseCode, new Response().description("successful operation").schema(property2).headers(defaultResponseHeaders));
                }
            } else if (!responseClass.equals(Void.class) && !responseClass.equals(Void.TYPE)) {
                models = ModelConverters.getInstance().read((Type)responseClass);
                if (models.isEmpty()) {
                    Property property = ModelConverters.getInstance().readAsProperty((Type)responseClass);
                    operation.response(responseCode, new Response().description("successful operation").schema(property).headers(defaultResponseHeaders));
                }
                for (String key : models.keySet()) {
                    Property responseProperty = RESPONSE_CONTAINER_CONVERTER.withResponseContainer(responseContainer, (Property)new RefProperty().asDefault(key));
                    operation.response(responseCode, new Response().description("successful operation").schema(responseProperty).headers(defaultResponseHeaders));
                    this.swagger.model(key, (Model)models.get(key));
                }
            }
            models = ModelConverters.getInstance().readAll((Type)responseClass);
            for (Map.Entry entry : models.entrySet()) {
                this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
            }
        }
        operation.operationId(operationId);
        for (String str : requestMapping.produces()) {
            if (produces.contains(str)) continue;
            produces.add(str);
        }
        for (String str : requestMapping.consumes()) {
            if (consumes.contains(str)) continue;
            consumes.add(str);
        }
        ApiResponses responseAnnotation = (ApiResponses)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiResponses.class);
        if (responseAnnotation != null) {
            this.updateApiResponse(operation, responseAnnotation);
        } else {
            ResponseStatus responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ResponseStatus.class);
            if (responseStatus != null) {
                operation.response(responseStatus.value().value(), new Response().description(responseStatus.reason()));
            }
        }
        Deprecated deprecated = (Deprecated)AnnotationUtils.findAnnotation((Method)method, Deprecated.class);
        if (deprecated != null) {
            operation.deprecated(Boolean.valueOf(true));
        }
        boolean hidden = false;
        if (apiOperation != null) {
            hidden = apiOperation.hidden();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        DefaultParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
        String[] parameterNames = parameterNameDiscoverer.getParameterNames(method);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type type = genericParameterTypes[i];
            List<Annotation> annotations = Arrays.asList(paramAnnotations[i]);
            List<Parameter> parameters = this.getParameters(type, annotations);
            for (Parameter parameter : parameters) {
                if (parameter.getName().isEmpty()) {
                    parameter.setName(parameterNames[i]);
                }
                operation.parameter(parameter);
            }
        }
        if (operation.getResponses() == null) {
            operation.defaultResponse(new Response().description("successful operation"));
        }
        this.readImplicitParameters(method, operation);
        this.processOperationDecorator(operation, method);
        return operation;
    }

    private Map<String, List<Method>> collectApisByRequestMapping(List<Method> methods) {
        HashMap<String, List<Method>> apiMethodMap = new HashMap<String, List<Method>>();
        for (Method method : methods) {
            RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
            if (requestMapping == null) continue;
            String path = requestMapping.value().length != 0 ? this.generateFullPath(requestMapping.value()[0]) : this.resourcePath;
            if (apiMethodMap.containsKey(path)) {
                ((List)apiMethodMap.get(path)).add(method);
                continue;
            }
            ArrayList<Method> ms = new ArrayList<Method>();
            ms.add(method);
            apiMethodMap.put(path, ms);
        }
        return apiMethodMap;
    }

    private String generateFullPath(String path) {
        if (StringUtils.isNotEmpty((String)path)) {
            return this.resourcePath + (path.startsWith("/") ? path : '/' + path);
        }
        return this.resourcePath;
    }

    @Deprecated
    private Class<?> getGenericSubtype(Class<?> clazz, Type type) {
        if (!clazz.getName().equals("void") && !type.toString().equals("void")) {
            try {
                ParameterizedType paramType = (ParameterizedType)type;
                Type[] argTypes = paramType.getActualTypeArguments();
                if (argTypes.length > 0) {
                    return (Class)argTypes[0];
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private Map<String, SpringResource> analyzeController(Class<?> controllerClazz, Map<String, SpringResource> resourceMap, String description) {
        String[] controllerRequestMappingValues;
        for (String controllerRequestMappingValue : controllerRequestMappingValues = SpringUtils.getControllerResquestMapping(controllerClazz)) {
            for (Method method : controllerClazz.getMethods()) {
                RequestMethod[] requestMappingRequestMethods;
                RequestMapping methodRequestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
                if (methodRequestMapping == null) continue;
                for (RequestMethod requestMappingRequestMethod : requestMappingRequestMethods = methodRequestMapping.method()) {
                    String[] methodRequestMappingValues = methodRequestMapping.value();
                    if (methodRequestMappingValues.length == 0) {
                        String resourceKey = controllerClazz.getCanonicalName() + controllerRequestMappingValue + requestMappingRequestMethod;
                        if (!resourceMap.containsKey(resourceKey)) {
                            resourceMap.put(resourceKey, new SpringResource(controllerClazz, controllerRequestMappingValue, resourceKey, description));
                        }
                        resourceMap.get(resourceKey).addMethod(method);
                        continue;
                    }
                    for (String methodRequestMappingValue : methodRequestMappingValues) {
                        String resourceKey = controllerClazz.getCanonicalName() + controllerRequestMappingValue + methodRequestMappingValue + requestMappingRequestMethod;
                        if (methodRequestMappingValue.isEmpty()) continue;
                        if (!resourceMap.containsKey(resourceKey)) {
                            resourceMap.put(resourceKey, new SpringResource(controllerClazz, methodRequestMappingValue, resourceKey, description));
                        }
                        resourceMap.get(resourceKey).addMethod(method);
                    }
                }
            }
        }
        controllerClazz.getFields();
        controllerClazz.getDeclaredFields();
        return resourceMap;
    }

    protected Map<String, SpringResource> generateResourceMap(Set<Class<?>> validClasses) throws GenerateException {
        Map<String, SpringResource> resourceMap = new HashMap<String, SpringResource>();
        for (Class<?> aClass : validClasses) {
            RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(aClass, RequestMapping.class);
            try {
                resourceMap = this.analyzeController(aClass, resourceMap, "");
                ArrayList<Method> mList = new ArrayList<Method>(Arrays.asList(aClass.getMethods()));
                if (aClass.getSuperclass() == null) continue;
                mList.addAll(Arrays.asList(aClass.getSuperclass().getMethods()));
            }
            catch (NoClassDefFoundError e) {
                this.LOG.error((CharSequence)e.getMessage());
                this.LOG.info((CharSequence)aClass.getName());
            }
        }
        return resourceMap;
    }
}

