/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.task;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.task.NodeSetupTask;
import com.github.gradle.node.util.PlatformHelper;
import com.github.gradle.node.util.ProjectApiHelper;
import com.github.gradle.node.variant.VariantComputer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0007J\b\u0010'\u001a\u00020%H\u0002J\b\u0010(\u001a\u00020%H\u0002R!\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u00020\u001b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/github/gradle/node/task/NodeSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "download", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getDownload", "()Lorg/gradle/api/provider/Property;", "nodeArchiveFile", "Lorg/gradle/api/file/RegularFileProperty;", "getNodeArchiveFile", "()Lorg/gradle/api/file/RegularFileProperty;", "nodeDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getNodeDir", "()Lorg/gradle/api/provider/Provider;", "nodeDir$delegate", "Lkotlin/Lazy;", "nodeExtension", "Lcom/github/gradle/node/NodeExtension;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "getObjects", "()Lorg/gradle/api/model/ObjectFactory;", "projectHelper", "Lcom/github/gradle/node/util/ProjectApiHelper;", "getProjectHelper", "()Lcom/github/gradle/node/util/ProjectApiHelper;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "variantComputer", "Lcom/github/gradle/node/variant/VariantComputer;", "deleteExistingNode", "", "exec", "setExecutableFlag", "unpackNodeArchive", "Companion", "gradle-node-plugin"})
public abstract class NodeSetupTask
extends DefaultTask {
    private final VariantComputer variantComputer = new VariantComputer(null, 1, null);
    private final NodeExtension nodeExtension;
    @NotNull
    private final Property<Boolean> download;
    @NotNull
    private final RegularFileProperty nodeArchiveFile;
    @NotNull
    private final Lazy nodeDir$delegate;
    @NotNull
    private final ProjectApiHelper projectHelper;
    @NotNull
    public static final String NAME = "nodeSetup";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Inject
    @NotNull
    public abstract ObjectFactory getObjects();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Input
    @NotNull
    public final Property<Boolean> getDownload() {
        return this.download;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getNodeArchiveFile() {
        return this.nodeArchiveFile;
    }

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getNodeDir() {
        Lazy lazy = this.nodeDir$delegate;
        NodeSetupTask nodeSetupTask = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @Internal
    @NotNull
    public final ProjectApiHelper getProjectHelper() {
        return this.projectHelper;
    }

    @TaskAction
    public final void exec() {
        this.deleteExistingNode();
        this.unpackNodeArchive();
        this.setExecutableFlag();
    }

    private final void deleteExistingNode() {
        this.projectHelper.delete((Action<DeleteSpec>)((Action)new Action<DeleteSpec>(this){
            final /* synthetic */ NodeSetupTask this$0;

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkParameterIsNotNull((Object)$this$delete, (String)"$receiver");
                $this$delete.delete(new Object[]{((Directory)this.this$0.getNodeDir().get()).dir("../")});
            }
            {
                this.this$0 = nodeSetupTask;
            }
        }));
    }

    private final void unpackNodeArchive() {
        Object object = this.nodeArchiveFile.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeArchiveFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"nodeArchiveFile.get().asFile");
        File archiveFile = file;
        Provider<Directory> nodeDirProvider = this.variantComputer.computeNodeDir(this.nodeExtension);
        Provider<Directory> nodeBinDirProvider = this.variantComputer.computeNodeBinDir(nodeDirProvider);
        String string = archiveFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"archiveFile.name");
        if (StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null)) {
            this.projectHelper.copy((Action<CopySpec>)((Action)new Action<CopySpec>(this, archiveFile, nodeDirProvider){
                final /* synthetic */ NodeSetupTask this$0;
                final /* synthetic */ File $archiveFile;
                final /* synthetic */ Provider $nodeDirProvider;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$copy, (String)"$receiver");
                    $this$copy.from(new Object[]{this.this$0.getProjectHelper().zipTree(this.$archiveFile)});
                    $this$copy.into((Object)this.$nodeDirProvider.map((Transformer)unpackNodeArchive.1.INSTANCE));
                }
                {
                    this.this$0 = nodeSetupTask;
                    this.$archiveFile = file;
                    this.$nodeDirProvider = provider;
                }
            }));
        } else {
            this.projectHelper.copy((Action<CopySpec>)((Action)new Action<CopySpec>(this, archiveFile, nodeDirProvider){
                final /* synthetic */ NodeSetupTask this$0;
                final /* synthetic */ File $archiveFile;
                final /* synthetic */ Provider $nodeDirProvider;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$copy, (String)"$receiver");
                    $this$copy.from(new Object[]{this.this$0.getProjectHelper().tarTree(this.$archiveFile)});
                    $this$copy.into((Object)this.$nodeDirProvider.map((Transformer)unpackNodeArchive.1.INSTANCE));
                }
                {
                    this.this$0 = nodeSetupTask;
                    this.$archiveFile = file;
                    this.$nodeDirProvider = provider;
                }
            }));
            Object object2 = nodeBinDirProvider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"nodeBinDirProvider.get()");
            Path nodeBinDirPath = ((Directory)object2).getAsFile().toPath();
            Path npm = nodeBinDirPath.resolve("npm");
            Object object3 = this.variantComputer.computeNpmScriptFile(nodeDirProvider, "npm").get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"variantComputer.computeN\u2026DirProvider, \"npm\").get()");
            String npmScriptFile = (String)object3;
            if (Files.deleteIfExists(npm)) {
                Files.createSymbolicLink(npm, nodeBinDirPath.relativize(Paths.get(npmScriptFile, new String[0])), new FileAttribute[0]);
            }
            Path npx = nodeBinDirPath.resolve("npx");
            Object object4 = this.variantComputer.computeNpmScriptFile(nodeDirProvider, "npx").get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"variantComputer.computeN\u2026DirProvider, \"npx\").get()");
            String npxScriptFile = (String)object4;
            if (Files.deleteIfExists(npx)) {
                Files.createSymbolicLink(npx, nodeBinDirPath.relativize(Paths.get(npxScriptFile, new String[0])), new FileAttribute[0]);
            }
        }
    }

    private final void setExecutableFlag() {
        if (!PlatformHelper.Companion.getINSTANCE().isWindows()) {
            Provider<Directory> nodeDirProvider = this.variantComputer.computeNodeDir(this.nodeExtension);
            Provider<Directory> nodeBinDirProvider = this.variantComputer.computeNodeBinDir(nodeDirProvider);
            Provider<String> nodeExecProvider = this.variantComputer.computeNodeExec(this.nodeExtension, nodeBinDirProvider);
            new File((String)nodeExecProvider.get()).setExecutable(true);
        }
    }

    public NodeSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.nodeExtension = NodeExtension.Companion.get(project);
        this.download = this.nodeExtension.getDownload();
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.nodeArchiveFile = regularFileProperty;
        this.nodeDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ NodeSetupTask this$0;

            @NotNull
            public final Provider<Directory> invoke() {
                return NodeSetupTask.access$getVariantComputer$p(this.this$0).computeNodeDir(NodeSetupTask.access$getNodeExtension$p(this.this$0));
            }
            {
                this.this$0 = nodeSetupTask;
                super(0);
            }
        }));
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        this.projectHelper = ProjectApiHelper.Companion.newInstance(project2);
        this.setGroup("Node");
        this.setDescription("Download and install a local node/npm version.");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = nodeExtension.getDownload().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeExtension.download.get()");
                return (Boolean)object;
            }
        });
    }

    public static final /* synthetic */ VariantComputer access$getVariantComputer$p(NodeSetupTask $this) {
        return $this.variantComputer;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/gradle/node/task/NodeSetupTask$Companion;", "", "()V", "NAME", "", "gradle-node-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

