/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.yarn.exec;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.exec.ExecConfiguration;
import com.github.gradle.node.exec.ExecRunner;
import com.github.gradle.node.exec.NodeExecConfiguration;
import com.github.gradle.node.npm.proxy.NpmProxy;
import com.github.gradle.node.npm.proxy.ProxySettings;
import com.github.gradle.node.util.ProjectApiHelper;
import com.github.gradle.node.util.ProviderKt;
import com.github.gradle.node.variant.VariantComputer;
import com.github.gradle.node.yarn.exec.YarnExecRunner;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/gradle/node/yarn/exec/YarnExecRunner;", "", "()V", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "variantComputer", "Lcom/github/gradle/node/variant/VariantComputer;", "addNpmProxyEnvironment", "", "", "nodeExtension", "Lcom/github/gradle/node/NodeExtension;", "nodeExecConfiguration", "Lcom/github/gradle/node/exec/NodeExecConfiguration;", "computeAdditionalBinPath", "Lorg/gradle/api/provider/Provider;", "", "nodeDirProvider", "Lorg/gradle/api/file/Directory;", "yarnBinDirProvider", "executeYarnCommand", "", "project", "Lcom/github/gradle/node/util/ProjectApiHelper;", "gradle-node-plugin"})
public abstract class YarnExecRunner {
    private final VariantComputer variantComputer = new VariantComputer(null, 1, null);

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    public final void executeYarnCommand(@NotNull ProjectApiHelper project, @NotNull NodeExtension nodeExtension, @NotNull NodeExecConfiguration nodeExecConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)nodeExtension, (String)"nodeExtension");
        Intrinsics.checkParameterIsNotNull((Object)nodeExecConfiguration, (String)"nodeExecConfiguration");
        Provider<Directory> nodeDirProvider = this.variantComputer.computeNodeDir(nodeExtension);
        Provider<Directory> yarnDirProvider = this.variantComputer.computeYarnDir(nodeExtension);
        Provider<Directory> yarnBinDirProvider = this.variantComputer.computeYarnBinDir(yarnDirProvider);
        Provider<String> yarnExecProvider = this.variantComputer.computeYarnExec(nodeExtension, yarnBinDirProvider);
        Provider<List<String>> additionalBinPathProvider = this.computeAdditionalBinPath(nodeExtension, nodeDirProvider, yarnBinDirProvider);
        Object object = yarnExecProvider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"yarnExecProvider.get()");
        String string = (String)object;
        List<String> list = nodeExecConfiguration.getCommand();
        Object object2 = additionalBinPathProvider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"additionalBinPathProvider.get()");
        ExecConfiguration execConfiguration = new ExecConfiguration(string, list, (List)object2, this.addNpmProxyEnvironment(nodeExtension, nodeExecConfiguration), nodeExecConfiguration.getWorkingDir(), nodeExecConfiguration.getIgnoreExitValue(), nodeExecConfiguration.getExecOverrides());
        ExecRunner execRunner = new ExecRunner();
        execRunner.execute(project, nodeExtension, execConfiguration);
    }

    private final Map<String, String> addNpmProxyEnvironment(NodeExtension nodeExtension, NodeExecConfiguration nodeExecConfiguration) {
        Map<String, String> map = System.getenv();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"System.getenv()");
        Object object = nodeExtension.getNodeProxySettings().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeExtension.nodeProxySettings.get()");
        if (NpmProxy.Companion.shouldConfigureProxy(map, (ProxySettings)((Object)object))) {
            Map<String, String> npmProxyEnvironmentVariables;
            Map<String, String> map2 = npmProxyEnvironmentVariables = NpmProxy.Companion.computeNpmProxyEnvironmentVariables();
            boolean bl = false;
            if (!map2.isEmpty()) {
                return MapsKt.plus(nodeExecConfiguration.getEnvironment(), npmProxyEnvironmentVariables);
            }
        }
        return nodeExecConfiguration.getEnvironment();
    }

    private final Provider<List<String>> computeAdditionalBinPath(NodeExtension nodeExtension, Provider<Directory> nodeDirProvider, Provider<Directory> yarnBinDirProvider) {
        Provider provider = nodeExtension.getDownload().flatMap((Transformer)new Transformer<Provider<? extends List<? extends String>>, Boolean>(this, nodeDirProvider, nodeExtension, yarnBinDirProvider){
            final /* synthetic */ YarnExecRunner this$0;
            final /* synthetic */ Provider $nodeDirProvider;
            final /* synthetic */ NodeExtension $nodeExtension;
            final /* synthetic */ Provider $yarnBinDirProvider;

            @NotNull
            public final Provider<? extends List<String>> transform(@NotNull Boolean download) {
                Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
                if (!download.booleanValue()) {
                    this.this$0.getProviders().provider((Callable)computeAdditionalBinPath.1.INSTANCE);
                }
                Provider<Directory> nodeBinDirProvider = YarnExecRunner.access$getVariantComputer$p(this.this$0).computeNodeBinDir((Provider<Directory>)this.$nodeDirProvider);
                Provider<Directory> npmDirProvider = YarnExecRunner.access$getVariantComputer$p(this.this$0).computeNpmDir(this.$nodeExtension, (Provider<Directory>)this.$nodeDirProvider);
                Provider<Directory> npmBinDirProvider = YarnExecRunner.access$getVariantComputer$p(this.this$0).computeNpmBinDir(npmDirProvider);
                return ProviderKt.zip(nodeBinDirProvider, npmBinDirProvider, this.$yarnBinDirProvider).map((Transformer)computeAdditionalBinPath.2.INSTANCE);
            }
            {
                this.this$0 = yarnExecRunner;
                this.$nodeDirProvider = provider;
                this.$nodeExtension = nodeExtension;
                this.$yarnBinDirProvider = provider2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"nodeExtension.download.f\u2026              }\n        }");
        return provider;
    }

    public static final /* synthetic */ VariantComputer access$getVariantComputer$p(YarnExecRunner $this) {
        return $this.variantComputer;
    }
}

