/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.NodePlugin;
import com.github.gradle.node.PackageJsonExtension;
import com.github.gradle.node.npm.proxy.ProxySettings;
import com.github.gradle.node.npm.task.NpmInstallTask;
import com.github.gradle.node.npm.task.NpmSetupTask;
import com.github.gradle.node.npm.task.NpmTask;
import com.github.gradle.node.npm.task.NpxTask;
import com.github.gradle.node.pnpm.task.PnpmInstallTask;
import com.github.gradle.node.pnpm.task.PnpmSetupTask;
import com.github.gradle.node.pnpm.task.PnpmTask;
import com.github.gradle.node.task.NodeSetupTask;
import com.github.gradle.node.task.NodeTask;
import com.github.gradle.node.util.OsType;
import com.github.gradle.node.util.Platform;
import com.github.gradle.node.util.PlatformHelperKt;
import com.github.gradle.node.variant.VariantComputerKt;
import com.github.gradle.node.yarn.task.YarnInstallTask;
import com.github.gradle.node.yarn.task.YarnSetupTask;
import com.github.gradle.node.yarn.task.YarnTask;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.process.ExecOutput;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u00020\u0006\"\u0006\b\u0000\u0010\u0007\u0018\u0001H\u0082\bJ\b\u0010\b\u001a\u00020\u0006H\u0002J\u0016\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001f\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0006H\u0002J\u0016\u0010\u0017\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/github/gradle/node/NodePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "project", "addGlobalType", "", "T", "addGlobalTypes", "addNpmRule", "enableTaskRules", "Lorg/gradle/api/provider/Property;", "", "addPlatform", "extension", "Lcom/github/gradle/node/NodeExtension;", "addPnpmRule", "addRepository", "distUrl", "", "allowInsecureProtocol", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "addTasks", "addYarnRule", "apply", "configureNodeExtension", "configureNodeSetupTask", "nodeExtension", "resolveNodeArchiveFile", "Ljava/io/File;", "name", "Companion", "gradle-node-plugin"})
public final class NodePlugin
implements Plugin<Project> {
    private Project project;
    @NotNull
    private static final GradleVersion MINIMAL_SUPPORTED_GRADLE_VERSION;
    @NotNull
    public static final String NODE_GROUP = "Node";
    @NotNull
    public static final String NPM_GROUP = "npm";
    @NotNull
    public static final String PNPM_GROUP = "pnpm";
    @NotNull
    public static final String YARN_GROUP = "Yarn";
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        void name$iv;
        void $this$create$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        NodeExtension nodeExtension = NodeExtension.Companion.create(project);
        this.configureNodeExtension(nodeExtension);
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer extensionContainer2 = extensionContainer;
        String string = "packageJson";
        Object[] constructionArguments$iv = new Object[]{project};
        boolean $i$f$create = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv.create((String)name$iv, PackageJsonExtension.class, Arrays.copyOf(constructionArguments$iv, constructionArguments$iv.length)), (String)"create(name, T::class.ja\u2026, *constructionArguments)");
        this.addGlobalTypes();
        this.addTasks();
        this.addNpmRule(nodeExtension.getEnableTaskRules());
        this.addPnpmRule(nodeExtension.getEnableTaskRules());
        this.addYarnRule(nodeExtension.getEnableTaskRules());
        project.afterEvaluate(new Action(this, nodeExtension){
            final /* synthetic */ NodePlugin this$0;
            final /* synthetic */ NodeExtension $nodeExtension;

            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$receiver");
                Object object = this.$nodeExtension.getDownload().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeExtension.download.get()");
                if (((Boolean)object).booleanValue()) {
                    String string = (String)this.$nodeExtension.getDistBaseUrl().getOrNull();
                    if (string != null) {
                        String string2;
                        String it = string2 = string;
                        boolean bl = false;
                        String string3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                        NodePlugin.access$addRepository(this.this$0, string3, (Boolean)this.$nodeExtension.getAllowInsecureProtocol().getOrNull());
                    }
                    NodePlugin.access$configureNodeSetupTask(this.this$0, this.$nodeExtension);
                }
            }
            {
                this.this$0 = nodePlugin;
                this.$nodeExtension = nodeExtension;
            }
        });
    }

    private final void configureNodeExtension(NodeExtension extension) {
        DirectoryProperty directoryProperty;
        this.addPlatform(extension);
        DirectoryProperty $this$with = directoryProperty = extension.getResolvedNodeDir();
        boolean bl = false;
        $this$with.set(VariantComputerKt.computeNodeDir(extension));
        $this$with.finalizeValueOnRead();
        $this$with = directoryProperty = extension.getComputedNodeDir();
        boolean bl2 = false;
        $this$with.convention((Provider)extension.getResolvedNodeDir());
        $this$with.finalizeValueOnRead();
    }

    private final void addPlatform(NodeExtension extension) {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"os.name\")");
        OsType osType = PlatformHelperKt.parseOsType(string);
        String arch = System.getProperty("os.arch");
        Action unameSpec2 = new Action(osType){
            final /* synthetic */ OsType $osType;

            public final void execute(@NotNull ExecSpec $this$Action) {
                Intrinsics.checkNotNullParameter((Object)$this$Action, (String)"$receiver");
                if (this.$osType == OsType.WINDOWS) {
                    $this$Action.setExecutable("powershell");
                    $this$Action.setArgs(CollectionsKt.listOf((Object[])new String[]{"-NoProfile", "-Command", "(Get-WmiObject Win32_Processor).Architecture"}));
                } else {
                    $this$Action.setExecutable("uname");
                    $this$Action.setArgs(CollectionsKt.listOf((Object)"-m"));
                }
            }
            {
                this.$osType = osType;
            }
        };
        Function0 uname2 = (Function0)new Function0<String>(this, unameSpec2){
            final /* synthetic */ NodePlugin this$0;
            final /* synthetic */ Action $unameSpec;

            @NotNull
            public final String invoke() {
                String string;
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.5")) >= 0) {
                    ExecOutput execOutput = NodePlugin.access$getProject$p(this.this$0).getProviders().exec(this.$unameSpec);
                    Intrinsics.checkNotNullExpressionValue((Object)execOutput, (String)"project.providers.exec(unameSpec)");
                    ExecOutput cmd2 = execOutput;
                    ExecOutput.StandardStreamContent standardStreamContent = cmd2.getStandardOutput();
                    Intrinsics.checkNotNullExpressionValue((Object)standardStreamContent, (String)"cmd.standardOutput");
                    Object object = standardStreamContent.getAsText().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cmd.standardOutput.asText.get()");
                    String string2 = (String)object;
                    string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                } else {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    NodePlugin.access$getProject$p(this.this$0).exec(this.$unameSpec);
                    ExecResult execResult = NodePlugin.access$getProject$p(this.this$0).exec(new Action(this, out){
                        final /* synthetic */ addPlatform.uname.1 this$0;
                        final /* synthetic */ ByteArrayOutputStream $out;

                        public final void execute(@NotNull ExecSpec $this$exec) {
                            Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$receiver");
                            this.this$0.$unameSpec.execute((Object)$this$exec);
                            $this$exec.setStandardOutput((OutputStream)this.$out);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$out = byteArrayOutputStream;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)execResult, (String)"project.exec {\n         \u2026t = out\n                }");
                    ExecResult cmd3 = execResult;
                    cmd3.assertNormalExitValue();
                    String string3 = out.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"out.toString()");
                    String string4 = string3;
                    string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                }
                return string;
            }
            {
                this.this$0 = nodePlugin;
                this.$unameSpec = action;
                super(0);
            }
        };
        String string2 = arch;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"arch");
        Platform platform = PlatformHelperKt.parsePlatform(osType, string2, (Function0<String>)uname2);
        extension.getResolvedPlatform().set((Object)platform);
        extension.getComputedPlatform().convention((Provider)extension.getResolvedPlatform());
    }

    private final void addGlobalTypes() {
        NodePlugin this_$iv = this;
        boolean $i$f$addGlobalType = false;
        ExtensionContainer extensionContainer = NodePlugin.access$getProject$p(this_$iv).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        extensionContainer.getExtraProperties().set(NodeTask.class.getSimpleName(), NodeTask.class);
        this_$iv = this;
        $i$f$addGlobalType = false;
        ExtensionContainer extensionContainer2 = NodePlugin.access$getProject$p(this_$iv).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer2, (String)"project.extensions");
        extensionContainer2.getExtraProperties().set(NpmTask.class.getSimpleName(), NpmTask.class);
        this_$iv = this;
        $i$f$addGlobalType = false;
        ExtensionContainer extensionContainer3 = NodePlugin.access$getProject$p(this_$iv).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer3, (String)"project.extensions");
        extensionContainer3.getExtraProperties().set(NpxTask.class.getSimpleName(), NpxTask.class);
        this_$iv = this;
        $i$f$addGlobalType = false;
        ExtensionContainer extensionContainer4 = NodePlugin.access$getProject$p(this_$iv).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer4, (String)"project.extensions");
        extensionContainer4.getExtraProperties().set(PnpmTask.class.getSimpleName(), PnpmTask.class);
        this_$iv = this;
        $i$f$addGlobalType = false;
        ExtensionContainer extensionContainer5 = NodePlugin.access$getProject$p(this_$iv).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer5, (String)"project.extensions");
        extensionContainer5.getExtraProperties().set(YarnTask.class.getSimpleName(), YarnTask.class);
        this_$iv = this;
        $i$f$addGlobalType = false;
        ExtensionContainer extensionContainer6 = NodePlugin.access$getProject$p(this_$iv).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer6, (String)"project.extensions");
        extensionContainer6.getExtraProperties().set(ProxySettings.class.getSimpleName(), ProxySettings.class);
    }

    private final /* synthetic */ <T> void addGlobalType() {
        int $i$f$addGlobalType = 0;
        ExtensionContainer extensionContainer = NodePlugin.access$getProject$p(this).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtraPropertiesExtension extraPropertiesExtension = extensionContainer.getExtraProperties();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Object.class.getSimpleName();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        extraPropertiesExtension.set(string, Object.class);
    }

    private final void addTasks() {
        TaskContainer $this$register$iv;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String name$iv = "npmInstall";
        boolean $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, NpmInstallTask.class), (String)"register(name, T::class.java)");
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        TaskContainer taskContainer3 = project2.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"project.tasks");
        $this$register$iv = taskContainer3;
        name$iv = "pnpmInstall";
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, PnpmInstallTask.class), (String)"register(name, T::class.java)");
        Project project3 = this.project;
        if (project3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        TaskContainer taskContainer4 = project3.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer4, (String)"project.tasks");
        $this$register$iv = taskContainer4;
        name$iv = "yarn";
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, YarnInstallTask.class), (String)"register(name, T::class.java)");
        Project project4 = this.project;
        if (project4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        TaskContainer taskContainer5 = project4.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer5, (String)"project.tasks");
        $this$register$iv = taskContainer5;
        name$iv = "nodeSetup";
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, NodeSetupTask.class), (String)"register(name, T::class.java)");
        Project project5 = this.project;
        if (project5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        TaskContainer taskContainer6 = project5.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer6, (String)"project.tasks");
        $this$register$iv = taskContainer6;
        name$iv = "npmSetup";
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, NpmSetupTask.class), (String)"register(name, T::class.java)");
        Project project6 = this.project;
        if (project6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        TaskContainer taskContainer7 = project6.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer7, (String)"project.tasks");
        $this$register$iv = taskContainer7;
        name$iv = "pnpmSetup";
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, PnpmSetupTask.class), (String)"register(name, T::class.java)");
        Project project7 = this.project;
        if (project7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        TaskContainer taskContainer8 = project7.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer8, (String)"project.tasks");
        $this$register$iv = taskContainer8;
        name$iv = "yarnSetup";
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, YarnSetupTask.class), (String)"register(name, T::class.java)");
    }

    private final void addNpmRule(Property<Boolean> enableTaskRules) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        project.getTasks().addRule("Pattern: \"npm_<command>\": Executes an NPM command.", new Action(this, enableTaskRules){
            final /* synthetic */ NodePlugin this$0;
            final /* synthetic */ Property $enableTaskRules;

            /*
             * WARNING - void declaration
             */
            public final void execute(@NotNull String $this$addRule) {
                Intrinsics.checkNotNullParameter((Object)$this$addRule, (String)"$receiver");
                String taskName = $this$addRule;
                if (StringsKt.startsWith$default((String)taskName, (String)"npm_", (boolean)false, (int)2, null)) {
                    Object object = this.$enableTaskRules.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"enableTaskRules.get()");
                    if (((Boolean)object).booleanValue()) {
                        void $this$create$iv;
                        TaskContainer taskContainer = NodePlugin.access$getProject$p(this.this$0).getTasks();
                        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                        PolymorphicDomainObjectContainer polymorphicDomainObjectContainer = (PolymorphicDomainObjectContainer)taskContainer;
                        Function1 configuration$iv = (Function1)new Function1<NpmTask, Unit>(taskName){
                            final /* synthetic */ String $taskName;

                            public final void invoke(@NotNull NpmTask $this$create) {
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$create), (String)"$receiver");
                                List tokens = CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)this.$taskName, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null), (int)1);
                                $this$create.getNpmCommand().set((Iterable)tokens);
                                if (StringsKt.equals((String)((String)CollectionsKt.first((List)tokens)), (String)"run", (boolean)true)) {
                                    $this$create.dependsOn(new Object[]{"npmInstall"});
                                }
                            }
                            {
                                this.$taskName = string;
                                super(1);
                            }
                        };
                        boolean $i$f$create = false;
                        Function1 function1 = configuration$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv.create(taskName, NpmTask.class, new Action(function1){
                            private final /* synthetic */ Function1 function;
                            {
                                this.function = function1;
                            }

                            public final /* synthetic */ void execute(Object p0) {
                                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                            }
                        }), (String)"this.create(name, U::class.java, configuration)");
                    }
                }
            }
            {
                this.this$0 = nodePlugin;
                this.$enableTaskRules = property;
            }
        });
    }

    private final void addPnpmRule(Property<Boolean> enableTaskRules) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        project.getTasks().addRule("Pattern: \"pnpm_<command>\": Executes an PNPM command.", new Action(this, enableTaskRules){
            final /* synthetic */ NodePlugin this$0;
            final /* synthetic */ Property $enableTaskRules;

            /*
             * WARNING - void declaration
             */
            public final void execute(@NotNull String $this$addRule) {
                Intrinsics.checkNotNullParameter((Object)$this$addRule, (String)"$receiver");
                String taskName = $this$addRule;
                if (StringsKt.startsWith$default((String)taskName, (String)"pnpm_", (boolean)false, (int)2, null)) {
                    Object object = this.$enableTaskRules.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"enableTaskRules.get()");
                    if (((Boolean)object).booleanValue()) {
                        void $this$register$iv;
                        TaskContainer taskContainer = NodePlugin.access$getProject$p(this.this$0).getTasks();
                        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                        TaskContainer taskContainer2 = taskContainer;
                        Function1 configuration$iv = (Function1)new Function1<PnpmTask, Unit>(taskName){
                            final /* synthetic */ String $taskName;

                            public final void invoke(@NotNull PnpmTask $this$register) {
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                                List tokens = CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)this.$taskName, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null), (int)1);
                                $this$register.getPnpmCommand().set((Iterable)tokens);
                                if (StringsKt.equals((String)((String)CollectionsKt.first((List)tokens)), (String)"run", (boolean)true)) {
                                    $this$register.dependsOn(new Object[]{"pnpmInstall"});
                                }
                            }
                            {
                                this.$taskName = string;
                                super(1);
                            }
                        };
                        boolean $i$f$register = false;
                        Function1 function1 = configuration$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(taskName, PnpmTask.class, new Action(function1){
                            private final /* synthetic */ Function1 function;
                            {
                                this.function = function1;
                            }

                            public final /* synthetic */ void execute(Object p0) {
                                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                            }
                        }), (String)"register(name, T::class.java, configuration)");
                    }
                }
            }
            {
                this.this$0 = nodePlugin;
                this.$enableTaskRules = property;
            }
        });
    }

    private final void addYarnRule(Property<Boolean> enableTaskRules) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        project.getTasks().addRule("Pattern: \"yarn_<command>\": Executes an Yarn command.", new Action(this, enableTaskRules){
            final /* synthetic */ NodePlugin this$0;
            final /* synthetic */ Property $enableTaskRules;

            /*
             * WARNING - void declaration
             */
            public final void execute(@NotNull String $this$addRule) {
                Intrinsics.checkNotNullParameter((Object)$this$addRule, (String)"$receiver");
                String taskName = $this$addRule;
                if (StringsKt.startsWith$default((String)taskName, (String)"yarn_", (boolean)false, (int)2, null)) {
                    Object object = this.$enableTaskRules.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"enableTaskRules.get()");
                    if (((Boolean)object).booleanValue()) {
                        void $this$create$iv;
                        TaskContainer taskContainer = NodePlugin.access$getProject$p(this.this$0).getTasks();
                        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                        PolymorphicDomainObjectContainer polymorphicDomainObjectContainer = (PolymorphicDomainObjectContainer)taskContainer;
                        Function1 configuration$iv = (Function1)new Function1<YarnTask, Unit>(taskName){
                            final /* synthetic */ String $taskName;

                            public final void invoke(@NotNull YarnTask $this$create) {
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$create), (String)"$receiver");
                                List tokens = CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)this.$taskName, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null), (int)1);
                                $this$create.getYarnCommand().set((Iterable)tokens);
                                if (StringsKt.equals((String)((String)CollectionsKt.first((List)tokens)), (String)"run", (boolean)true)) {
                                    $this$create.dependsOn(new Object[]{"yarn"});
                                }
                            }
                            {
                                this.$taskName = string;
                                super(1);
                            }
                        };
                        boolean $i$f$create = false;
                        Function1 function1 = configuration$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv.create(taskName, YarnTask.class, new Action(function1){
                            private final /* synthetic */ Function1 function;
                            {
                                this.function = function1;
                            }

                            public final /* synthetic */ void execute(Object p0) {
                                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                            }
                        }), (String)"this.create(name, U::class.java, configuration)");
                    }
                }
            }
            {
                this.this$0 = nodePlugin;
                this.$enableTaskRules = property;
            }
        });
    }

    private final void addRepository(String distUrl, Boolean allowInsecureProtocol) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        project.getRepositories().ivy(new Action(distUrl, allowInsecureProtocol){
            final /* synthetic */ String $distUrl;
            final /* synthetic */ Boolean $allowInsecureProtocol;

            public final void execute(@NotNull IvyArtifactRepository $this$ivy) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$this$ivy, (String)"$receiver");
                    $this$ivy.setName("Node.js");
                    $this$ivy.setUrl((Object)this.$distUrl);
                    $this$ivy.patternLayout((Action)addRepository.1.INSTANCE);
                    $this$ivy.metadataSources((Action)addRepository.2.INSTANCE);
                    $this$ivy.content((Action)addRepository.3.INSTANCE);
                    Boolean bl = this.$allowInsecureProtocol;
                    if (bl == null) break block0;
                    Boolean bl2 = bl;
                    boolean it = bl2;
                    boolean bl3 = false;
                    $this$ivy.setAllowInsecureProtocol(it);
                }
            }
            {
                this.$distUrl = string;
                this.$allowInsecureProtocol = bl;
            }
        });
    }

    private final void configureNodeSetupTask(NodeExtension nodeExtension) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
        boolean $i$f$withType = false;
        TaskCollection taskCollection = $this$withType$iv.withType(NodeSetupTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
        taskCollection.configureEach(new Action(this, nodeExtension){
            final /* synthetic */ NodePlugin this$0;
            final /* synthetic */ NodeExtension $nodeExtension;

            public final void execute(@NotNull NodeSetupTask $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$configureEach), (String)"$receiver");
                $this$configureEach.getNodeDir().set((Provider)this.$nodeExtension.getResolvedNodeDir());
                Provider provider = VariantComputerKt.computeNodeArchiveDependency(this.$nodeExtension).map(new Transformer(this){
                    final /* synthetic */ configureNodeSetupTask.1 this$0;

                    @NotNull
                    public final File transform(@NotNull String nodeArchiveDependency) {
                        Intrinsics.checkNotNullParameter((Object)nodeArchiveDependency, (String)"nodeArchiveDependency");
                        return NodePlugin.access$resolveNodeArchiveFile(this.this$0.this$0, nodeArchiveDependency);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"computeNodeArchiveDepend\u2026cy)\n                    }");
                Provider archiveFileProvider2 = provider;
                RegularFileProperty regularFileProperty = $this$configureEach.getNodeArchiveFile();
                Project project = $this$configureEach.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                regularFileProperty.set(project.getLayout().file(archiveFileProvider2));
            }
            {
                this.this$0 = nodePlugin;
                this.$nodeExtension = nodeExtension;
            }
        });
    }

    private final File resolveNodeArchiveFile(String name2) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Dependency dependency = project.getDependencies().create((Object)name2);
        Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"project.dependencies.create(name)");
        Dependency dependency2 = dependency;
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Configuration configuration = project2.getConfigurations().detachedConfiguration(new Dependency[]{dependency2});
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.d\u2026Configuration(dependency)");
        Configuration configuration2 = configuration;
        configuration2.setTransitive(false);
        Set set = configuration2.resolve();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configuration.resolve()");
        Object object = CollectionsKt.single((Iterable)set);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configuration.resolve().single()");
        return (File)object;
    }

    static {
        Companion = new Companion(null);
        GradleVersion gradleVersion = GradleVersion.version((String)"6.6");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"GradleVersion.version(\"6.6\")");
        MINIMAL_SUPPORTED_GRADLE_VERSION = gradleVersion;
    }

    public static final /* synthetic */ void access$addRepository(NodePlugin $this, String distUrl, Boolean allowInsecureProtocol) {
        $this.addRepository(distUrl, allowInsecureProtocol);
    }

    public static final /* synthetic */ void access$configureNodeSetupTask(NodePlugin $this, NodeExtension nodeExtension) {
        $this.configureNodeSetupTask(nodeExtension);
    }

    public static final /* synthetic */ Project access$getProject$p(NodePlugin $this) {
        Project project = $this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project;
    }

    public static final /* synthetic */ void access$setProject$p(NodePlugin $this, Project project) {
        $this.project = project;
    }

    public static final /* synthetic */ File access$resolveNodeArchiveFile(NodePlugin $this, String name2) {
        return $this.resolveNodeArchiveFile(name2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/gradle/node/NodePlugin$Companion;", "", "()V", "MINIMAL_SUPPORTED_GRADLE_VERSION", "Lorg/gradle/util/GradleVersion;", "getMINIMAL_SUPPORTED_GRADLE_VERSION", "()Lorg/gradle/util/GradleVersion;", "NODE_GROUP", "", "NPM_GROUP", "PNPM_GROUP", "YARN_GROUP", "gradle-node-plugin"})
    public static final class Companion {
        @NotNull
        public final GradleVersion getMINIMAL_SUPPORTED_GRADLE_VERSION() {
            return MINIMAL_SUPPORTED_GRADLE_VERSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

