/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.npm.proxy;

import com.github.gradle.node.exec.NodeExecConfiguration;
import com.github.gradle.node.npm.proxy.NpmProxy;
import com.github.gradle.node.npm.proxy.ProxySettings;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/github/gradle/node/npm/proxy/NpmProxy;", "", "()V", "Companion", "gradle-node-plugin"})
public final class NpmProxy {
    private static final List<String> proxyVariables;
    private static final List<String> npmProxyVariables;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        proxyVariables = CollectionsKt.listOf((Object[])new String[]{"HTTP_PROXY", "HTTPS_PROXY", "NO_PROXY", "PROXY"});
        npmProxyVariables = CollectionsKt.listOf((Object[])new String[]{"NPM_CONFIG_PROXY", "NPM_CONFIG_HTTPS-PROXY", "NPM_CONFIG_HTTPS_PROXY", "NPM_CONFIG_NOPROXY"});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0011H\u0002J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018J\u001a\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rJ\"\u0010\u001c\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u001d\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/gradle/node/npm/proxy/NpmProxy$Companion;", "", "()V", "npmProxyVariables", "", "", "proxyVariables", "addProxyEnvironmentVariables", "Lcom/github/gradle/node/exec/NodeExecConfiguration;", "proxySettings", "Lcom/github/gradle/node/npm/proxy/ProxySettings;", "nodeExecConfiguration", "environment", "", "addProxyIgnoredHostsEnvironmentVariable", "", "proxyEnvironmentVariables", "", "computeNpmProxyEnvironmentVariables", "computeProxyIgnoredHosts", "computeProxyUrlEnvironmentVariables", "encode", "value", "getKnownProxyConfigurationKeys", "", "hasProxyConfiguration", "", "env", "shouldConfigureProxy", "settings", "gradle-node-plugin"})
    public static final class Companion {
        @NotNull
        public final Map<String, String> computeNpmProxyEnvironmentVariables() {
            Map<String, String> proxyEnvironmentVariables = this.computeProxyUrlEnvironmentVariables();
            Map<String, String> map = proxyEnvironmentVariables;
            if (!map.isEmpty()) {
                this.addProxyIgnoredHostsEnvironmentVariable(proxyEnvironmentVariables);
            }
            return MapsKt.toMap(proxyEnvironmentVariables);
        }

        public final boolean shouldConfigureProxy(@NotNull Map<String, String> env, @NotNull ProxySettings settings) {
            Intrinsics.checkNotNullParameter(env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            if (settings == ProxySettings.FORCED) {
                return true;
            }
            if (settings == ProxySettings.SMART) {
                return !this.hasProxyConfiguration(env);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasProxyConfiguration(@NotNull Map<String, String> env) {
            boolean bl;
            Intrinsics.checkNotNullParameter(env, (String)"env");
            Iterable $this$any$iv = env.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl2 = false;
                List list = proxyVariables;
                String string = it;
                String string2 = string.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase()");
                if (list.contains(string2)) return true;
                List list2 = npmProxyVariables;
                string = it;
                String string3 = string.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase()");
                if (list2.contains(string3)) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        @NotNull
        public final Set<String> getKnownProxyConfigurationKeys() {
            return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)proxyVariables, (Iterable)npmProxyVariables));
        }

        @NotNull
        public final NodeExecConfiguration addProxyEnvironmentVariables(@NotNull ProxySettings proxySettings, @NotNull NodeExecConfiguration nodeExecConfiguration, @NotNull Map<String, String> environment) {
            Intrinsics.checkNotNullParameter((Object)((Object)proxySettings), (String)"proxySettings");
            Intrinsics.checkNotNullParameter((Object)nodeExecConfiguration, (String)"nodeExecConfiguration");
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            if (this.shouldConfigureProxy(environment, proxySettings)) {
                Map<String, String> npmProxyEnvironmentVariables = this.computeNpmProxyEnvironmentVariables();
                Set<String> environmentVariablesToUnset = proxySettings == ProxySettings.FORCED ? this.getKnownProxyConfigurationKeys() : SetsKt.emptySet();
                Map<String, String> map = npmProxyEnvironmentVariables;
                if (!map.isEmpty()) {
                    Map environmentVariables = MapsKt.plus((Map)MapsKt.minus(nodeExecConfiguration.getEnvironment(), (Iterable)environmentVariablesToUnset), npmProxyEnvironmentVariables);
                    return NodeExecConfiguration.copy$default(nodeExecConfiguration, null, environmentVariables, null, false, null, 29, null);
                }
            }
            return nodeExecConfiguration;
        }

        public static /* synthetic */ NodeExecConfiguration addProxyEnvironmentVariables$default(Companion companion, ProxySettings proxySettings, NodeExecConfiguration nodeExecConfiguration, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                Map<String, String> map2 = System.getenv();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"System.getenv()");
                map = map2;
            }
            return companion.addProxyEnvironmentVariables(proxySettings, nodeExecConfiguration, map);
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, String> computeProxyUrlEnvironmentVariables() {
            Map proxyArgs = new LinkedHashMap();
            Iterator iterator = CollectionsKt.listOf((Object[])new String[][]{{"http", "HTTP_PROXY"}, {"https", "HTTPS_PROXY"}}).iterator();
            while (iterator.hasNext()) {
                void proxyProto;
                String[] stringArray;
                String[] stringArray2 = stringArray = (String[])iterator.next();
                String string = stringArray2[0];
                stringArray2 = stringArray;
                String proxyParam = stringArray2[1];
                String proxyHost = System.getProperty((String)proxyProto + ".proxyHost");
                String proxyPort = System.getProperty((String)proxyProto + ".proxyPort");
                if (proxyHost == null || proxyPort == null) continue;
                CharSequence charSequence = proxyHost;
                String string2 = "^https?://";
                string2 = new Regex(string2);
                String string3 = "";
                proxyHost = string2.replace(charSequence, string3);
                String proxyUser = System.getProperty((String)proxyProto + ".proxyUser");
                String proxyPassword = System.getProperty((String)proxyProto + ".proxyPassword");
                if (proxyUser != null && proxyPassword != null) {
                    proxyArgs.put(proxyParam, "http://" + this.encode(proxyUser) + ':' + this.encode(proxyPassword) + '@' + proxyHost + ':' + proxyPort);
                    continue;
                }
                proxyArgs.put(proxyParam, "http://" + proxyHost + ':' + proxyPort);
            }
            return proxyArgs;
        }

        private final String encode(String value) {
            String string = URLEncoder.encode(value, Charsets.UTF_8.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(value, UTF_8.toString())");
            return string;
        }

        private final void addProxyIgnoredHostsEnvironmentVariable(Map<String, String> proxyEnvironmentVariables) {
            List<String> proxyIgnoredHosts = this.computeProxyIgnoredHosts();
            Collection collection = proxyIgnoredHosts;
            if (!collection.isEmpty()) {
                proxyEnvironmentVariables.put("NO_PROXY", CollectionsKt.joinToString$default((Iterable)proxyIgnoredHosts, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
        }

        private final List<String> computeProxyIgnoredHosts() {
            Stream stream = Stream.of("http.nonProxyHosts", "https.nonProxyHosts").map(computeProxyIgnoredHosts.1.INSTANCE);
            Object object = computeProxyIgnoredHosts.2.INSTANCE;
            if (object != null) {
                Function1 function1 = object;
                object = new Function(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ Object apply(Object p0) {
                        return this.function.invoke(p0);
                    }
                };
            }
            List<String> list = stream.flatMap((Function)object).distinct().collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"Stream.of(\"http.nonProxy\u2026       .collect(toList())");
            return list;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

