/*
 * Decompiled with CFR 0.152.
 */
package com.github.stuxuhai.jpinyin;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PinyinResource {
    private PinyinResource() {
    }

    protected static Reader newClassPathReader(String classpath) {
        InputStream is = PinyinResource.class.getResourceAsStream(classpath);
        try {
            return new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    protected static Reader newFileReader(String path) throws FileNotFoundException {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    protected static Map<String, String> getResource(Reader reader) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        try {
            BufferedReader br = new BufferedReader(reader);
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.trim().split("=");
                map.put(tokens[0], tokens[1]);
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    protected static Map<String, String> getPinyinResource() {
        return PinyinResource.getResource(PinyinResource.newClassPathReader("/data/pinyin.dict"));
    }

    protected static Map<String, String> getMutilPinyinResource() {
        return PinyinResource.getResource(PinyinResource.newClassPathReader("/data/mutil_pinyin.dict"));
    }

    protected static Map<String, String> getChineseResource() {
        return PinyinResource.getResource(PinyinResource.newClassPathReader("/data/chinese.dict"));
    }
}

