/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.ApplicationOpener;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationWriter;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class DexClassSource
implements ClassSource {
    private final ApplicationReader applicationReader;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;
    private final DexClassFileFactory classFileFactory;

    DexClassSource(ApplicationReader applicationReader, File cacheDir, DexFileLoader dexFileLoader, DexClassFileFactory classFileFactory) {
        this.applicationReader = applicationReader;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
        this.classFileFactory = classFileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile getClassFile(String className) throws IOException {
        ApplicationWriter aw = new ApplicationWriter();
        String[] classesToVisit = new String[]{'L' + className.replace('.', '/') + ';'};
        this.applicationReader.accept((ApplicationVisitor)new ApplicationOpener((ApplicationVisitor)aw), classesToVisit, 0);
        byte[] bytes = aw.toByteArray();
        if (bytes == null) {
            return null;
        }
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new IllegalStateException("Cannot create " + this.cacheDir);
        }
        File zip = File.createTempFile("classes", ".zip", this.cacheDir);
        try {
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));){
                out.putNextEntry(new ZipEntry("classes.dex"));
                out.write(bytes);
            }
            String sourcePathName = zip.getCanonicalPath();
            File dex = new File(sourcePathName + ".dex");
            DexFile dexFile = this.dexFileLoader.loadDex(sourcePathName, dex.getCanonicalPath(), 0);
            ClassFile classFile = this.classFileFactory.create(className, dexFile);
            return classFile;
        }
        finally {
            if (zip.exists() && !zip.delete()) {
                Logger.getLogger("com.github.tmurakami.dexopener").warning("Cannot delete " + zip);
            }
        }
    }

    static final class Factory {
        private final File cacheDir;

        Factory(File cacheDir) {
            this.cacheDir = cacheDir;
        }

        ClassSource create(byte[] bytes) {
            return new DexClassSource(new ApplicationReader(262144, bytes), this.cacheDir, DexFileLoader.INSTANCE, DexClassFileFactory.INSTANCE);
        }
    }
}

