/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.support.test.runner.AndroidJUnitRunner;
import com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassSourceImpl;
import com.github.tmurakami.dexopener.DexClassSource;
import java.io.File;
import java.util.logging.Logger;

public class DexOpener
extends AndroidJUnitRunner {
    private boolean initialized;

    public void onCreate(Bundle arguments) {
        this.init();
        super.onCreate(arguments);
    }

    public Application newApplication(ClassLoader cl, String className, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.init();
        return super.newApplication(cl, className, context);
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Context context = this.getTargetContext();
        ApplicationInfo ai = context.getApplicationInfo();
        File cacheDir = new File(ai.dataDir, "code_cache/dexopener");
        if (cacheDir.isDirectory()) {
            DexOpener.deleteFiles(cacheDir.listFiles());
        }
        DexClassSource.Factory dexClassSourceFactory = new DexClassSource.Factory(cacheDir);
        ClassSourceImpl source = new ClassSourceImpl(ai.sourceDir, new ClassNameFilter(), dexClassSourceFactory);
        ClassInjector.from((ClassSource)source).into(context.getClassLoader());
    }

    private static void deleteFiles(File[] files) {
        for (File f : files) {
            if (f.isDirectory()) {
                DexOpener.deleteFiles(f.listFiles());
            }
            if (!f.exists() || f.delete()) continue;
            Logger.getLogger("com.github.tmurakami.dexopener").warning("Cannot delete " + f);
        }
    }
}

