/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueUtil;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueShort
extends EncodedValue {
    private int type = 2;
    private short value;

    public EncodedValueShort(short value) {
        this.value = value;
    }

    public EncodedValueShort(Object value) {
        this.value = (Short)value;
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        return EncodedValueUtil.encodeSignedValue(Short.valueOf(this.value).shortValue(), this.type);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueShort) {
            EncodedValueShort encodedValue = (EncodedValueShort)o;
            result = this.type == encodedValue.type && this.value == encodedValue.value;
        }
        return result;
    }

    public int hashCode() {
        return this.type + this.value * 15796;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueShort es = (EncodedValueShort)encodedValue;
        short value2 = es.value;
        return this.value == value2 ? 0 : (this.value > value2 ? 1 : -1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

