/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.support.annotation.NonNull;
import com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.ApplicationOpener;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationWriter;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class DexClassSource
implements ClassSource {
    private final ApplicationReader applicationReader;
    private final Set<String> classNames;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;
    private final DexClassFileFactory classFileFactory;

    DexClassSource(ApplicationReader applicationReader, Set<String> classNames, File cacheDir, DexFileLoader dexFileLoader, DexClassFileFactory classFileFactory) {
        this.applicationReader = applicationReader;
        this.classNames = classNames;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
        this.classFileFactory = classFileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile getClassFile(@NonNull String className) throws IOException {
        if (!this.classNames.contains(className)) {
            return null;
        }
        ApplicationWriter aw = new ApplicationWriter();
        String[] classesToVisit = new String[]{'L' + className.replace('.', '/') + ';'};
        this.applicationReader.accept((ApplicationVisitor)new ApplicationOpener((ApplicationVisitor)aw), classesToVisit, 0);
        byte[] bytes = aw.toByteArray();
        if (bytes == null) {
            return null;
        }
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new IllegalStateException("Cannot create " + this.cacheDir);
        }
        File zip = File.createTempFile("classes", ".zip", this.cacheDir);
        try {
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));){
                out.putNextEntry(new ZipEntry("classes.dex"));
                out.write(bytes);
            }
            String sourcePathName = zip.getCanonicalPath();
            DexFile dexFile = this.dexFileLoader.loadDex(sourcePathName, sourcePathName + ".dex", 0);
            ClassFile classFile = this.classFileFactory.newClassFile(className, dexFile);
            return classFile;
        }
        finally {
            if (zip.exists() && !zip.delete()) {
                Logger.getLogger("com.github.tmurakami.dexopener").warning("Cannot delete " + zip);
            }
        }
    }
}

