/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import androidx.annotation.NonNull;
import com.github.tmurakami.dexopener.ClassInjector;
import com.github.tmurakami.dexopener.ClassLoaderHelper;
import com.github.tmurakami.dexopener.ClassPath;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexNameFilter;
import com.github.tmurakami.dexopener.Loggers;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DexOpener {
    private static final String[] REFUSED_PACKAGES = new String[]{"com.github.tmurakami.dexopener.", "android.", "androidx.", "com.android.", "com.google.android.", "com.sun.", "dalvik.", "java.", "javax.", "libcore.", "org.apache.commons.logging.", "org.apache.harmony.", "org.apache.http.", "org.ccil.cowan.tagsoup.", "org.json.", "org.kxml2.io.", "org.w3c.dom.", "org.xml.sax.", "org.xmlpull.v1.", "sun.", "junit.", "org.hamcrest.", "org.junit."};
    private static final Executor EXECUTOR;

    private DexOpener() {
        throw new AssertionError((Object)"Do not instantiate");
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        ClassLoader loader;
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            String instrumentationName = instrumentation.getClass().getSimpleName();
            throw new IllegalStateException("The " + instrumentationName + " instance has not yet been initialized");
        }
        Context app = context.getApplicationContext();
        if (app != null) {
            throw new IllegalStateException("The " + app.getClass().getSimpleName() + " instance has already been created");
        }
        for (ClassLoader l = loader = context.getClassLoader(); l != null; l = l.getParent()) {
            if (!(l instanceof ClassInjector)) continue;
            throw new IllegalStateException("Already installed");
        }
        DexNameFilter dexNameFilter = DexOpener.createDexNameFilter(instrumentation.getClass());
        ClassPath classPath = new ClassPath(context, dexNameFilter, new DexFileLoader(), EXECUTOR);
        ClassLoaderHelper.setParent((ClassLoader)loader, (ClassLoader)new ClassInjector(loader, classPath));
    }

    private static DexNameFilter createDexNameFilter(Class<?> rootClass) {
        String packageName;
        String className = rootClass.getName();
        int lastDotPos = className.lastIndexOf(46);
        String string = packageName = lastDotPos == -1 ? null : className.substring(0, lastDotPos);
        if (DexOpener.isSupportedPackage(packageName)) {
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("The final classes under " + packageName + " will be opened");
            }
            return new DexNameFilter(packageName, rootClass);
        }
        throw new UnsupportedOperationException("Install to an Instrumentation instance the package of which is " + packageName);
    }

    private static boolean isSupportedPackage(String packageName) {
        if (packageName == null || packageName.indexOf(46) == -1) {
            return false;
        }
        for (String pkg : REFUSED_PACKAGES) {
            if (!packageName.startsWith(pkg)) continue;
            return false;
        }
        return true;
    }

    static {
        AtomicInteger count = new AtomicInteger();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int nThreads = Math.max(1, Math.min(availableProcessors, 4));
        EXECUTOR = Executors.newFixedThreadPool(nThreads, r -> new Thread(r, "DexOpener #" + count.incrementAndGet()));
    }
}

